% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demod.R
\name{new_swdft_matching_demod}
\alias{new_swdft_matching_demod}
\title{Constructor function for class 'swdft_matching_demod'}
\usage{
new_swdft_matching_demod(x, n, fitted, thresh, max_cycles, smooth, order,
  passfreqs, maxvals, freqs, khats, amps, phases, demods, cycle, resids,
  fits, return_rows)
}
\arguments{
\item{x}{numeric. Signal to demodulate}

\item{n}{integer. Window size for SWDFT}

\item{fitted}{fitted values}

\item{thresh}{numeric. Threshold to determine whether to continue demodulating}

\item{max_cycles}{maximum number of demodulation cycles}

\item{smooth}{character. Type of smoothing to use, accepts either 'ma', 'double_ma',
or 'butterworth' (the default)}

\item{order}{moving average parameter if 'smooth' argument equals 'ma' or 'double_ma'. Defaults to 5}

\item{passfreqs}{pass frequency used in each iteration}

\item{maxvals}{Maximum SWDFT coefficient for each iteration}

\item{freqs}{Frequencies used in each iteration}

\item{khats}{Integer version of frequency.}

\item{amps}{Instantaneous amplitude for each iteration}

\item{phases}{Instantaneous phase for each iteration}

\item{demods}{List of demodulated signal and smoothed demodulated signal for each iteration}

\item{cycle}{Number of cycles used}

\item{resids}{Residuals for each iteration}

\item{fits}{Fitted values for each iteration}

\item{return_rows}{Logical vector indicating which iterations occurred. Used for subsetting.}
}
\value{
list with the following elements
\itemize{
  \item coefficients. coefficients from the R local signals with time-varying amplitude and phase model.
  \item fitted. fitted values of cosine regression model
  \item residuals. residuals of cosine regression model
  \item data. original signal used to fit cosine regression
  \item smooth. list with the filter used ('smooth') and parameters ('order' for 'ma' or 'double_ma', 'passfreq' for butterworth)
  \item demod. list w/ the demodulated signal, and smoothed demodulated signal
  \item thresh. Threshold used.
  \item iterations. List of fits, residuals, and maximum values for each iteration
}
}
\description{
Constructor function for class 'swdft_matching_demod'
}
