% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reformat.syntenyData.R
\name{reformat.syntenyData}
\alias{reformat.syntenyData}
\title{Reformat synteny data}
\usage{
reformat.syntenyData(
  file_data,
  filename,
  directory = NULL,
  reference.species = reference.sps,
  target.species = target.sps
)
}
\arguments{
\item{file_data}{input file name for descrambler .map data}

\item{filename}{output file name for reformatted data}

\item{directory}{string containing file path to chosen directory to save text file}

\item{reference.species}{reference species identifier as a character string}

\item{target.species}{target species identifier as a character string}
}
\value{
A text file with the reformatted data
}
\description{
Reformat synteny data
}
\details{
This function takes output from alignment softwares such as deschrambler and inferCARs and re-formats it for syntenyPlotteR - this does not curate files only re-formats it

It requires as input:
\enumerate{
\item The data output from deschrambler or inferCARs
\item the desired output file name
}

There are optional parameters for some customization of this function:
\enumerate{
\item reference.species allows you to set the reference species identifier that will be set in the final output table i.e. \code{reference.species = "ref"}
\item target.species allows you to set the target species identifier that will be set in the final output table i.e. \code{target.species = "tar"}
\item The directory where the text file should be saved, as default the file is saved to temporary directory, change by inputting: \code{directory = "path/to/directory"}
}

Example: \code{reformat.syntenyData("deschrambler.output", "reformatted.data", directory = "path/to/directory", reference.species = "ref", target.species = "tar" )}
}
\examples{

# Create object containing file path to external dataset
# (see vignette to follow examples with personal data)

file <- system.file("extdata", "example_map_1.map", package = "syntenyPlotteR")

# -----------------------------------------------------------------------------------

# Run reformat.syntenyData function
# To run example and save file to working directory
# add directory parameter and set working directory
# To run example with personal data see vignette

reformat.syntenyData(file, "outputName")
}
