% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers.R
\name{optimizer_lazy_adam}
\alias{optimizer_lazy_adam}
\title{Lazy Adam}
\usage{
optimizer_lazy_adam(
  learning_rate = 0.001,
  beta_1 = 0.9,
  beta_2 = 0.999,
  epsilon = 1e-07,
  amsgrad = FALSE,
  name = "LazyAdam",
  clipnorm = NULL,
  clipvalue = NULL,
  decay = NULL,
  lr = NULL
)
}
\arguments{
\item{learning_rate}{A Tensor or a floating point value. or a schedule that is a tf.keras.optimizers.schedules.LearningRateSchedule The learning rate.}

\item{beta_1}{A float value or a constant float tensor. The exponential decay rate for the 1st moment estimates.}

\item{beta_2}{A float value or a constant float tensor. The exponential decay rate for the 2nd moment estimates.}

\item{epsilon}{A small constant for numerical stability. This epsilon is "epsilon hat" in Adam: A Method for Stochastic Optimization. Kingma et al., 2014 (in the formula just before Section 2.1), not the epsilon in Algorithm 1 of the paper.}

\item{amsgrad}{boolean. Whether to apply AMSGrad variant of this algorithm from the paper "On the Convergence of Adam and beyond". Note that this argument is currently not supported and the argument can only be False.}

\item{name}{Optional name for the operations created when applying gradients. Defaults to "LazyAdam".}

\item{clipnorm}{is clip gradients by norm;}

\item{clipvalue}{is clip gradients by value,}

\item{decay}{is included for backward compatibility to allow time inverse decay of learning rate.}

\item{lr}{is included for backward compatibility, recommended to use learning_rate instead.}
}
\value{
Optimizer for use with `keras::compile()`
}
\description{
Lazy Adam
}
\examples{

\dontrun{
keras_model_sequential() \%>\%
  layer_dense(32, input_shape = c(784)) \%>\%
  compile(
    optimizer = optimizer_lazy_adam(),
    loss='binary_crossentropy',
    metrics='accuracy'
  )
}


}
