% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq2seq.R
\name{sampler_scheduled_output_training}
\alias{sampler_scheduled_output_training}
\title{Scheduled Output Training Sampler}
\usage{
sampler_scheduled_output_training(
  sampling_probability,
  time_major = FALSE,
  seed = NULL,
  next_inputs_fn = NULL
)
}
\arguments{
\item{sampling_probability}{A float32 scalar tensor: the probability of sampling
from the outputs instead of reading directly from the inputs.}

\item{time_major}{bool. Whether the tensors in inputs are time major. If False (default),
they are assumed to be batch major.}

\item{seed}{The sampling seed.}

\item{next_inputs_fn}{(Optional) callable to apply to the RNN outputs to create the next
input when sampling. If None (default), the RNN outputs will be used as the next inputs.}
}
\value{
FALSE for sample_ids where no sampling took place; TRUE elsewhere.
}
\description{
A training sampler that adds scheduled sampling directly to outputs.
}
