% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{setCustomTime}
\alias{setCustomTime}
\title{Adjust the time of a custom time bar}
\usage{
setCustomTime(id, time, itemId)
}
\arguments{
\item{id}{Timeline id or a \code{timevis} object (the output from \code{timevis()})}

\item{time}{The new date/time}

\item{itemId}{The id of the custom time bar}
}
\description{
Adjust the time of a custom time bar
}
\examples{
\dontrun{
timevis() \%>\%
  addCustomTime(Sys.Date(), "yesterday") \%>\%
  setCustomTime(Sys.Date() - 1, "yesterday")
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn", "Set time bar 24 hours ago")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis() \%>\% addCustomTime(Sys.Date(), "yesterday")
    )
    observeEvent(input$btn, {
      setCustomTime("timeline", Sys.Date() - 1, "yesterday")
    })
  }
)
}
}
