% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{setOptions}
\alias{setOptions}
\title{Update the configuration options of a timeline}
\usage{
setOptions(id, options)
}
\arguments{
\item{id}{Timeline id or a \code{timevis} object (the output from \code{timevis()})}

\item{options}{A named list containing updated configuration options to use.
See the \code{options} parameter of the
\code{\link[timevis]{timevis}} function to see more details.}
}
\description{
Update the configuration options of a timeline
}
\examples{
\dontrun{
timevis(
  data.frame(start = Sys.Date(), content = "Today"),
  options = list(showCurrentTime = FALSE, orientation = "top")
) \%>\%
  setOptions(list(editable = TRUE, showCurrentTime = TRUE))
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn", "Show current time and allow items to be editable")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis(
        data.frame(start = Sys.Date(), content = "Today"),
        options = list(showCurrentTime = FALSE, orientation = "top")
      )
    )
    observeEvent(input$btn, {
      setOptions("timeline", list(editable = TRUE, showCurrentTime = TRUE))
    })
  }
)
}
}
