% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tween_polygon.R
\name{st_normalize}
\alias{st_normalize}
\title{Normalise a geometry to fit inside a unit square}
\usage{
st_normalize(st)
}
\arguments{
\item{st}{An sf geometry such as \code{sf}, \code{sfc}, or \code{sfg}}
}
\value{
An object of the same type as \code{st}
}
\description{
This is a small helper function that will take an sf geometry and fit it
inside the unit square (a square centered on 0 and ranging from -1 to 1 in
both dimensions). The function will retain the aspect ratio of the geometry
and simply scale it down until it fits.
}
\examples{
library(sf)
nc <- st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)
st_bbox(nc)

nc_norm <- st_normalize(nc)
st_bbox(nc_norm)

}
