% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uhclust.R
\name{plot_uhclust}
\alias{plot_uhclust}
\title{Plot function for the result of uhclust}
\usage{
plot_uhclust(
  uhclust,
  pvalues_cex = 0.8,
  pvalues_dx = 2,
  pvalues_dy = 0.08,
  print_pvalues = TRUE
)
}
\arguments{
\item{uhclust}{Result from \code{uhclust}}

\item{pvalues_cex}{Graphical parameter for p-value font size.}

\item{pvalues_dx}{Graphical parameter for p-value position shift on x axis.}

\item{pvalues_dy}{Graphical parameter for p-value position shift on y axis.}

\item{print_pvalues}{Logical. Should the p-values be printed?}
}
\description{
This function plots the p-value annotated dendrogram resulting from \code{uhclust}
}
\examples{

x = matrix(rnorm(100000),nrow=50)
x[1:35,] = x[1:35,]+0.7
x[1:15,] = x[1:15,]+0.4
res = uhclust(data=x, plot=FALSE)
plot_uhclust(res)

}
