% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.processing.R
\name{post.processing}
\alias{post.processing}
\title{Post-processing of variants to generate outputs}
\usage{
post.processing(variant.specification, project.directory,
  config.file = NULL, variant.callers = NULL,
  remove.structural.variants = TRUE,
  separate.consensus.filters = FALSE, sleep = FALSE, verbose = FALSE)
}
\arguments{
\item{variant.specification}{Data frame specifying variants to be processed, or path to data frame (useful if calling from Perl)}

\item{project.directory}{Directory where output should be stored. Output files will be saved to a datestamped subdirectory}

\item{config.file}{Path to config file specifying post-processing options. If not provided, the current options are used (i.e. from \code{get.varitas.options()})}

\item{variant.callers}{Optional vector of variant callers for which filters should be included in Excel file}

\item{remove.structural.variants}{Logical indicating whether structural variants (including CNVs) should be removed. Defaults to TRUE.}

\item{separate.consensus.filters}{Logical indicating whether to apply different thresholds to variants called by more than one caller 
(specified under consensus in config file). Defaults to FALSE.}

\item{sleep}{Logical indicating whether script should sleep for 60 seconds before starting.}

\item{verbose}{Logical indicating whether to print verbose output}
}
\value{
None
}
\description{
Post-processing of variants to generate outputs
}
