% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature_conversions.R
\name{convert_temperature}
\alias{convert_temperature}
\title{Convert from one temperature metric to another}
\usage{
convert_temperature(temperature, old_metric, new_metric, round = 2)
}
\arguments{
\item{temperature}{A numeric vector of temperatures to be converted.}

\item{old_metric}{The metric from which you want to convert. Possible options are:
\itemize{
\item \code{fahrenheit}, \code{f}
\item \code{kelvin}, \code{k}
\item \code{celsius}, \code{c}
}}

\item{new_metric}{The metric to which you want to convert. The same options
are possible as for \code{old_metric}.}

\item{round}{An integer indicating the number of decimal places to
round the converted value.}
}
\value{
A numeric vector with temperature converted to the metric specified
   by the argument \code{new_metric}.
}
\description{
This function allows you to convert a vector of temperature values between
Fahrenheit, Celsius, and degrees Kelvin.
}
\examples{
data(lyon)
lyon$TemperatureF <- convert_temperature(lyon$TemperatureC,
   old_metric = "c", new_metric = "f")
lyon

data(norfolk)
norfolk$TempC <- convert_temperature(norfolk$TemperatureF,
   old_metric = "f", new_metric = "c")
norfolk

data(angeles)
angeles$TemperatureC <- convert_temperature(angeles$TemperatureK,
   old_metric = "kelvin", new_metric = "celsius")
angeles

}
\author{
#' Joshua Ferreri \email{joshua.m.ferreri@gmail.com},
Brooke Anderson \email{brooke.anderson@colostate.edu}
}

