% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature_conversions.R
\name{celsius.to.fahrenheit}
\alias{celsius.to.fahrenheit}
\title{Convert from Celsius to Fahrenheit.}
\usage{
celsius.to.fahrenheit(T.celsius, round = 2)
}
\arguments{
\item{T.celsius}{Numeric vector of temperatures in Celsius.}

\item{round}{An integer indicating the number of decimal places to
round the converted value.}
}
\value{
A numeric vector of temperature values in Fahrenheit.
}
\description{
\code{celsius.to.fahrenheit} creates a numeric vector of temperatures in
   Fahrenheit from a numeric vector of temperatures in Celsius.
}
\note{
Equations are from the source code for the US National Weather
    Service's
    \href{http://www.wpc.ncep.noaa.gov/html/heatindex.shtml}{online heat index calculator}.
}
\examples{
# Convert from Celsius to Fahrenheit.
data(lyon)
lyon$TemperatureF <- celsius.to.fahrenheit(lyon$TemperatureC)
lyon

}
\author{
Brooke Anderson \email{brooke.anderson@colostate.edu},
Roger Peng \email{rdpeng@gmail.com}
}
\seealso{
\code{\link{fahrenheit.to.celsius}}
}

