% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mileage_distribution.R
\name{dist_mileage.default}
\alias{dist_mileage.default}
\title{Parameter Estimation of an Annual Mileage Distribution}
\usage{
\method{dist_mileage}{default}(x, time, distribution = c("lognormal", "exponential"), ...)
}
\arguments{
\item{x}{A numeric vector of distances covered. Use \code{NA} for missing elements.}

\item{time}{A numeric vector of operating times. Use \code{NA} for missing elements.}

\item{distribution}{Supposed distribution of the annual mileage.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}
}
\value{
A list with class \code{wt_mileage_estimation} which contains:
\itemize{
\item \code{coefficients} : A named vector of estimated parameter(s).
\item \code{miles_annual} : A numeric vector of element-wise computed annual distances
using the linear relationship described in 'Details'.
\item \code{distribution} : Specified distribution.
}
}
\description{
This function models a mileage random variable on an annual basis with respect
to a supposed continuous distribution. First, the distances are calculated for
one year (365 days) using a linear relationship between the distance and
operating time. Second, the parameter(s) of the assumed distribution are
estimated with maximum likelihood. See 'Details' for more information.
}
\details{
The distribution parameter(s) is (are) determined on the basis of complete cases,
i.e. there is no \code{NA} in one of the related vector elements
\code{c(mileage[i], time[i])}. Distances and operating times less than or equal
to zero are not considered as well.

\strong{Assumption of linear relationship}: Imagine a component in a vehicle
has endured a distance of 25000 kilometers (km) in 500 days (d), the annual
distance of this unit is \deqn{25000 km \cdot (\frac{365 d} {500 d}) = 18250 km}{%
                25000 km * (365 d / 500 d) = 18250 km}
}
\examples{
# Example 1 - Assuming lognormal annual mileage distribution:
params_mileage_annual <- dist_mileage(
  x = field_data$mileage,
  time = field_data$dis,
  distribution = "lognormal"
)

# Example 2 - Assuming exponential annual mileage distribution:
params_mileage_annual_2 <- dist_mileage(
  x = field_data$mileage,
  time = field_data$dis,
  distribution = "exponential"
)

}
\seealso{
\link{dist_mileage}
}
