% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fb_player_goal_logs.R
\name{fb_player_goal_logs}
\alias{fb_player_goal_logs}
\title{Get player goal logs}
\usage{
fb_player_goal_logs(player_urls, time_pause = 3, goals_or_assists = "goals")
}
\arguments{
\item{player_urls}{the URL(s) of the player(s)}

\item{time_pause}{the wait time (in seconds) between page loads}

\item{goals_or_assists}{select whether to return data of "goals" (the default), "assists", or "both"}
}
\value{
returns a dataframe of the player's goals and assists
}
\description{
Returns the player's career goal and assist logs
}
\examples{
\dontrun{
try({
# for single players:
jwp_url <- "https://fbref.com/en/players/3515d404/"
fb_player_goal_logs(player_urls = jwp_url, goals_or_assists = "goals")
})
}
}
