% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_tests.R
\name{GOF_far}
\alias{GOF_far}
\title{Goodness-of-fit test for FAR(1)}
\usage{
GOF_far(
  f_data,
  lag = 5,
  M = 10000,
  alpha = 0.05,
  suppress_raw_output = FALSE,
  suppress_print_output = FALSE
)
}
\arguments{
\item{f_data}{The functional data matrix with observed functions in the columns.}

\item{lag}{Positive integer value. A user-selected maximum lag. 10 by default.}

\item{M}{Positive integer value. Number of Monte-Carlo simulation for Welch-Satterthwaite approximation.10000 by default.}

\item{alpha}{Numeric value between 0 and 1 specifying the significance level to be used in the specified
hypothesis test. The default value is 0.05. Note, the significance value is only ever used to compute the
1-alpha quantile of the limiting distribution of the specified test's test statistic.}

\item{suppress_raw_output}{Boolean value, FALSE by default. If TRUE, the function will not return the list
containing the p-value, quantile, and statistic.}

\item{suppress_print_output}{Boolean value, FALSE by default. If TRUE, the function will not print any
output to the console.}
}
\value{
If suppress_raw_output = FALSE, a list containing the test statistic, the 1-alpha quantile of the
limiting distribution, and the p-value computed from the specified hypothesis test. Also prints output
containing a short description of the test, the p-value, and additional information about the test if
suppress_print_output = FALSE.
}
\description{
The "GOF_far" test fits a FAR(1) model and then assesses the cumulative significance of lagged
autocovariance operators from the model residuals, up to a user-selected maximum lag K.
More specifically, it tests the null hypothesis that the first K lag-h autocovariance
operators (h going from 1 to K) from the model residuals is equal to 0.
}
\details{
`GOF_far` computes the goodness-of-fit test for FAR(1) over a range of user-specified lags.
}
\examples{
f <- far_1_S(100, 50, 0.75)
GOF_far(f, lag=5)

}
\references{
[1] Kim, M., Kokoszka, P., & Rice, G. (2023). White noise testing for functional time series. Statistic Surveys, 17, 119-168.
}
