% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.pfi.R
\name{grnn.pfi}
\alias{grnn.pfi}
\title{Derive the PFI rank of all predictors used in the GRNN}
\usage{
grnn.pfi(net, class = FALSE, ntry = 1000, seed = 1)
}
\arguments{
\item{net}{The GRNN object generated by grnn.fit()}

\item{class}{TRUE or FALSE, whether it is for the classification or not}

\item{ntry}{The number of random permutations to try, 1e3 times by default}

\item{seed}{The seed value for the random permutation}
}
\value{
A dataframe with PFI values of all predictors in the GRNN
}
\description{
The function \code{grnn.pfi} derives the PFI rank of all predictors used in the GRNN
It essentially is a wrapper around the function \code{grnn.x_pfi}.
}
\examples{
data(iris, package = "datasets")
Y <- ifelse(iris[, 5] == "setosa", 1, 0)
X <- scale(iris[, 1:3])
gnet <- grnn.fit(x = X, y = Y)
\dontrun{
grnn.pfi(net = gnet, class = TRUE)
}
}
\seealso{
\code{\link{grnn.x_pfi}}
}
