/*
 * Decompiled with CFR 0.152.
 */
package rfdd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import rfdd.chainons.LecteurFichier;
import rfdd.chainons.Pipeline;
import rfdd.chainons.SortieFichier;
import rfdd.gui.BadParamException;
import rfdd.gui.ExecutePipelineAction;
import rfdd.gui.FileBox;
import rfdd.gui.FilePrettyfier;
import rfdd.gui.WidgetChainonAppariement;
import rfdd.gui.WidgetChainonCalibration;
import rfdd.gui.WidgetChainonProfilEnClair;
import rfdd.gui.WidgetChainonRealigneur;
import rfdd.gui.WidgetChainonRecalculeProfil;
import rfdd.gui.WidgetChainonRecalculeTailleRef;
import rfdd.gui.WidgetChainonSelectionneCompatibles;

public class GUI
extends JFrame {
    private FileBox inputFileComponent = new FileBox("Fichier en entr\u00e9e", this, FilePrettyfier.READONLY);
    private WidgetChainonRealigneur chainonRealigneurComponent = new WidgetChainonRealigneur();
    private WidgetChainonRecalculeTailleRef chainonRecalculeTailleRefComponent = new WidgetChainonRecalculeTailleRef();
    private WidgetChainonCalibration chainonCalibrationComponent = new WidgetChainonCalibration();
    private WidgetChainonRecalculeProfil chainonRecalculeProfilComponent = new WidgetChainonRecalculeProfil();
    private WidgetChainonAppariement chainonAppariementComponent = new WidgetChainonAppariement();
    private WidgetChainonSelectionneCompatibles chainonSelectionneCompatiblesComponent = new WidgetChainonSelectionneCompatibles();
    private WidgetChainonProfilEnClair chainonProfilEnClairComponent = new WidgetChainonProfilEnClair();
    private FileBox outputFileComponent = new FileBox("Fichier de sortie", this, FilePrettyfier.WRITE);

    public static void main(String[] args) throws IOException {
        GUI gui = new GUI();
        gui.setDefaultCloseOperation(3);
        gui.pack();
        gui.setVisible(true);
    }

    public GUI() throws IOException {
        this.setTitle("R\u00e9organisaton + analyse RFDD");
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JTextPane haut = new JTextPane();
        haut.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        haut.setContentType("text/html");
        haut.setPage(this.getClass().getResource("/description.html"));
        haut.setMargin(new Insets(10, 10, 10, 10));
        haut.setEditable(false);
        Box pipelineBox = Box.createVerticalBox();
        pipelineBox.add(this.inputFileComponent);
        pipelineBox.add(this.chainonRealigneurComponent);
        pipelineBox.add(this.chainonRecalculeTailleRefComponent);
        pipelineBox.add(this.chainonCalibrationComponent);
        pipelineBox.add(this.chainonRecalculeProfilComponent);
        pipelineBox.add(this.chainonAppariementComponent);
        pipelineBox.add(this.chainonSelectionneCompatiblesComponent);
        pipelineBox.add(this.chainonProfilEnClairComponent);
        pipelineBox.add(this.outputFileComponent);
        JPanel bas = new JPanel();
        bas.setLayout(new FlowLayout());
        JButton b = new JButton(new ExecutePipelineAction(this));
        bas.add(b);
        contentPane.add((Component)haut, "West");
        contentPane.add((Component)pipelineBox, "Center");
        contentPane.add((Component)bas, "South");
        this.setContentPane(contentPane);
    }

    private String getDescription() {
        URL location = this.getClass().getResource("/description.html");
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(location.openStream()));
            String ligne = r.readLine();
            while (ligne != null) {
                sb.append(ligne).append('\n');
                ligne = r.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        return sb.toString();
    }

    public Pipeline buildPipeline() throws BadParamException {
        SortieFichier sortie;
        File outFile;
        LecteurFichier entree;
        Pipeline pipeline = new Pipeline();
        File inFile = this.inputFileComponent.getFile();
        if (inFile.isDirectory() || !inFile.canRead()) {
            throw new BadParamException("Impossible de prendre " + inFile.getName() + " comme fichier d'entr\u00e9e");
        }
        try {
            entree = new LecteurFichier(inFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new BadParamException("Probl\u00e8me \u00e0 l'ouverture de " + inFile.getName(), fnfe);
        }
        pipeline.add(entree);
        if (this.chainonRealigneurComponent.actif()) {
            pipeline.add(this.chainonRealigneurComponent.getChainon());
        }
        if (this.chainonRecalculeTailleRefComponent.actif()) {
            pipeline.add(this.chainonRecalculeTailleRefComponent.getChainon());
        }
        if (this.chainonCalibrationComponent.actif()) {
            pipeline.add(this.chainonCalibrationComponent.getChainon());
        }
        if (this.chainonRecalculeProfilComponent.actif()) {
            pipeline.add(this.chainonRecalculeProfilComponent.getChainon());
        }
        if (this.chainonAppariementComponent.actif()) {
            pipeline.add(this.chainonAppariementComponent.getChainon());
        }
        if (this.chainonSelectionneCompatiblesComponent.actif()) {
            pipeline.add(this.chainonSelectionneCompatiblesComponent.getChainon());
        }
        if (this.chainonProfilEnClairComponent.actif()) {
            pipeline.add(this.chainonProfilEnClairComponent.getChainon());
        }
        if ((outFile = this.outputFileComponent.getFile()).exists() && (outFile.isDirectory() || !outFile.canWrite())) {
            throw new BadParamException("Impossible de prendre " + outFile.getName() + " comme fichier de sortie");
        }
        try {
            sortie = new SortieFichier(outFile, "ISO-8859-1");
        }
        catch (IOException ioe) {
            throw new BadParamException("Probl\u00e8me \u00e0 l'ouverture de " + outFile.getName(), ioe);
        }
        pipeline.add(sortie);
        return pipeline;
    }
}

