/*
 * Decompiled with CFR 0.152.
 */
package rfdd.chainons;

import rfdd.beans.ListeMesures;
import rfdd.beans.Mesure;
import rfdd.beans.PetitGroupe;
import rfdd.chainons.ChainonSimple;

public class ChainonCalibration
extends ChainonSimple {
    private final float calibre;
    private boolean bloquerLigne;
    private float tailleAmplicon;

    public ChainonCalibration(float calibre) {
        this.calibre = calibre;
    }

    public void startPetitGroupe(PetitGroupe pg) {
        this.tailleAmplicon = pg.getTailleAmplicon();
        super.startPetitGroupe(pg);
    }

    public void startLigne(ListeMesures l) {
        float tailleRef = l.getTailleRef();
        if (Float.isNaN(tailleRef)) {
            throw new IllegalArgumentException("la taille de r\u00e9f\u00e9rence n'a pas \u00e9t\u00e9 recalcul\u00e9e");
        }
        boolean bl = this.bloquerLigne = !(Math.abs(tailleRef - this.tailleAmplicon) <= this.calibre * this.tailleAmplicon);
        if (!this.bloquerLigne) {
            super.startLigne(l);
        }
    }

    public void mesure(Mesure m) {
        if (!this.bloquerLigne) {
            super.mesure(m);
        }
    }

    public void stopLigne() {
        if (!this.bloquerLigne) {
            super.stopLigne();
        }
    }

    public String toString() {
        return "{Calibration: calibre=" + this.calibre + "}";
    }
}

