/*
 * Decompiled with CFR 0.152.
 */
package rfdd.chainons;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import rfdd.beans.ListeMesures;
import rfdd.beans.ListeMesures2;
import rfdd.beans.Mesure;
import rfdd.chainons.ChainonSimple;

public class ChainonRecalculeProfil
extends ChainonSimple {
    private final float seuilCodeBiChar;
    private final Map correspondances;
    private ListeMesures2 ligneEnCours;
    private float fluo_Hp;
    private float fluo_Hm;
    private float fluo_N;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ChainonRecalculeProfil(float seuilCodeBiChar) {
        this.seuilCodeBiChar = seuilCodeBiChar;
        this.correspondances = new HashMap();
        this.correspondances.put("--", Arrays.asList("Activ\u00e9 par l'hypoxie"));
        this.correspondances.put("-=", Arrays.asList("Activ\u00e9 par l'hypoxie", "(Inhib\u00e9 par l'hypoxie moyenne)", "(Non modifi\u00e9 par O2)"));
        this.correspondances.put("-+", Arrays.asList("Inhib\u00e9 par l'hypoxie moyenne"));
        this.correspondances.put("=-", Arrays.asList("Activ\u00e9 par l'hypoxie moyenne", "(Non modifi\u00e9 par O2)", "(Activ\u00e9 par l'hypoxie)"));
        this.correspondances.put("==", Arrays.asList("Non modifi\u00e9 par O2"));
        this.correspondances.put("=+", Arrays.asList("(Inhib\u00e9 par l'hypoxie moyenne)", "Activ\u00e9 par la normoxie", "(Non modifi\u00e9 par O2)"));
        this.correspondances.put("+-", Arrays.asList("Activ\u00e9 par l'hypoxie moyenne"));
        this.correspondances.put("+=", Arrays.asList("(Activ\u00e9 par la normoxie)", "(Non modifi\u00e9 par O2)", "Activ\u00e9 par l'hypoxie moyenne"));
        this.correspondances.put("++", Arrays.asList("Activ\u00e9 par la normoxie"));
    }

    public void startLigne(ListeMesures l) {
        if (!$assertionsDisabled && l == null) {
            throw new AssertionError();
        }
        this.ligneEnCours = new ListeMesures2(l);
        this.fluo_Hp = 0.0f;
        this.fluo_Hm = 0.0f;
        this.fluo_N = 0.0f;
    }

    public void mesure(Mesure m) {
        if ("Hp".equals(m.getConditions())) {
            this.fluo_Hp = m.getFluo();
        } else if ("Hm".equals(m.getConditions())) {
            this.fluo_Hm = m.getFluo();
        } else if ("N".equals(m.getConditions())) {
            this.fluo_N = m.getFluo();
        }
        this.ligneEnCours.add(m);
    }

    public void stopLigne() {
        float max = Float.MIN_VALUE;
        if (this.fluo_Hp > max) {
            max = this.fluo_Hp;
        }
        if (this.fluo_Hm > max) {
            max = this.fluo_Hm;
        }
        if (this.fluo_N > max) {
            max = this.fluo_N;
        }
        String codeBiChar = this.calculeCodeBichar(this.fluo_Hp / max, this.fluo_Hm / max, this.fluo_N / max);
        List profilsCompatibles = (List)this.correspondances.get(codeBiChar);
        Iterator ip = profilsCompatibles.iterator();
        while (ip.hasNext()) {
            String profil = (String)ip.next();
            ListeMesures lm = new ListeMesures(this.ligneEnCours);
            lm.setProfil(profil);
            lm.setCodeBiChar(codeBiChar);
            super.startLigne(lm);
            Iterator im = this.ligneEnCours.iterator();
            while (im.hasNext()) {
                super.mesure((Mesure)im.next());
            }
            super.stopLigne();
        }
        this.ligneEnCours = null;
    }

    private String calculeCodeBichar(float mesure1, float mesure2, float mesure3) {
        if (!($assertionsDisabled || 0.0f <= mesure1 && mesure1 <= 1.0f)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0.0f <= mesure2 && mesure2 <= 1.0f)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0.0f <= mesure3 && mesure3 <= 1.0f)) {
            throw new AssertionError();
        }
        String code = mesure1 >= mesure2 + this.seuilCodeBiChar ? "-" : (mesure1 + this.seuilCodeBiChar <= mesure2 ? "+" : "=");
        code = code + (mesure2 >= mesure3 + this.seuilCodeBiChar ? "-" : (mesure2 + this.seuilCodeBiChar <= mesure3 ? "+" : "="));
        return code;
    }

    public String toString() {
        return "{RecalculeProfil: seuil=" + this.seuilCodeBiChar + "}";
    }

    static {
        $assertionsDisabled = !ChainonRecalculeProfil.class.desiredAssertionStatus();
    }
}

