/*
 * Decompiled with CFR 0.152.
 */
package rfdd.chainons;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rfdd.beans.GrandGroupe;
import rfdd.beans.ListeMesures;
import rfdd.beans.Mesure;
import rfdd.beans.PetitGroupe;
import rfdd.chainons.ChainonSimple;
import rfdd.gui.evt.ProgressEvent;
import rfdd.gui.evt.ProgressListener;

public class LecteurFichier
extends ChainonSimple {
    private String fileName = "N/C";
    private LineNumberReader in;
    private List listeners = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public LecteurFichier() {
        this(new InputStreamReader(System.in));
        this.fileName = "<stdin>";
    }

    public LecteurFichier(File f) throws FileNotFoundException {
        this(new FileReader(f));
        this.fileName = f.getPath();
    }

    private LecteurFichier(Reader input) {
        this.in = new LineNumberReader(input);
    }

    public void lire() throws IOException {
        this.startFichier(this.fileName);
        String[] champs = this.getNextLine();
        while (champs != null) {
            int noPCR = Integer.parseInt(champs[0]);
            String amorce = champs[1];
            float tailleRef = LecteurFichier.parseFloat(champs[2]);
            int tailleAmplicon = Integer.parseInt(champs[3]);
            float taille_Hp = LecteurFichier.parseFloat(champs[4]);
            float taille_Hm = LecteurFichier.parseFloat(champs[5]);
            float taille_N = LecteurFichier.parseFloat(champs[6]);
            float fluo_Hp = LecteurFichier.parseFloat(champs[7]);
            float fluo_Hm = LecteurFichier.parseFloat(champs[8]);
            float fluo_N = LecteurFichier.parseFloat(champs[9]);
            String profil = champs[10];
            String noGenBank = champs[11].trim();
            String gene = champs[12];
            String product = champs[13];
            String redondance = champs[14];
            String tripletDebut = champs[15];
            String tripletFin = champs[16];
            String run = champs[17];
            String commentaire = champs[18];
            String enzyme = champs[19];
            GrandGroupe gg = new GrandGroupe();
            gg.setNoGenBank(noGenBank);
            gg.setGene(gene);
            gg.setProduct(product);
            gg.setRedondance(redondance);
            gg.setRun(run);
            this.startGrandGroupe(gg);
            while (noGenBank.equals(gg.getNoGenBank()) && champs != null) {
                if (!$assertionsDisabled && !noGenBank.equals(gg.getNoGenBank())) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !gene.equals(gg.getGene())) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !product.equals(gg.getProduct())) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !redondance.equals(gg.getRedondance())) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !run.equals(gg.getRun())) {
                    throw new AssertionError();
                }
                PetitGroupe pg = new PetitGroupe();
                pg.setTailleAmplicon(tailleAmplicon);
                pg.setNoPCR(noPCR);
                pg.setEnzyme(enzyme);
                pg.setAmorce(amorce);
                pg.setTripletDebut(tripletDebut);
                pg.setTripletFin(tripletFin);
                this.startPetitGroupe(pg);
                while (pg.getTailleAmplicon() == tailleAmplicon && pg.getNoPCR() == noPCR && pg.getEnzyme().equals(enzyme) && champs != null) {
                    if (!$assertionsDisabled && tailleAmplicon != pg.getTailleAmplicon()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && noPCR != pg.getNoPCR()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !enzyme.equals(pg.getEnzyme())) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !amorce.equals(pg.getAmorce())) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !tripletDebut.equals(pg.getTripletDebut())) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !tripletFin.equals(pg.getTripletFin())) {
                        throw new AssertionError();
                    }
                    ListeMesures lm = new ListeMesures();
                    lm.setProfil(profil);
                    lm.setTailleRef(tailleRef);
                    this.startLigne(lm);
                    if ((double)taille_Hp != 0.0) {
                        this.mesure(new Mesure(taille_Hp, fluo_Hp, "Hp"));
                    }
                    if ((double)taille_Hm != 0.0) {
                        this.mesure(new Mesure(taille_Hm, fluo_Hm, "Hm"));
                    }
                    if ((double)taille_N != 0.0) {
                        this.mesure(new Mesure(taille_N, fluo_N, "N"));
                    }
                    this.stopLigne();
                    champs = this.getNextLine();
                    if (champs == null) continue;
                    noPCR = Integer.parseInt(champs[0]);
                    amorce = champs[1];
                    tailleRef = LecteurFichier.parseFloat(champs[2]);
                    tailleAmplicon = Integer.parseInt(champs[3]);
                    taille_Hp = LecteurFichier.parseFloat(champs[4]);
                    taille_Hm = LecteurFichier.parseFloat(champs[5]);
                    taille_N = LecteurFichier.parseFloat(champs[6]);
                    fluo_Hp = LecteurFichier.parseFloat(champs[7]);
                    fluo_Hm = LecteurFichier.parseFloat(champs[8]);
                    fluo_N = LecteurFichier.parseFloat(champs[9]);
                    profil = champs[10];
                    noGenBank = champs[11].trim();
                    gene = champs[12];
                    product = champs[13];
                    redondance = champs[14];
                    tripletDebut = champs[15];
                    tripletFin = champs[16];
                    run = champs[17];
                    commentaire = champs[18];
                    enzyme = champs[19];
                }
                this.stopPetitGroupe();
            }
            this.stopGrandGroupe();
        }
        this.stopFichier();
    }

    private String[] getNextLine() throws IOException {
        String ligne = this.in.readLine();
        while (ligne != null && !this.valide(ligne, this.in.getLineNumber())) {
            ligne = this.in.readLine();
        }
        return ligne == null ? null : ligne.split("\t");
    }

    private static float parseFloat(String s) {
        return Float.parseFloat(s.replace(',', '.'));
    }

    private boolean valide(String ligne, int noLigne) {
        String[] champs = ligne.split("\t");
        if (champs.length < 20) {
            System.err.println("Ligne " + noLigne + " ne contient que" + champs.length + "colonnes: " + ligne);
            return false;
        }
        if (!champs[0].matches("[0-9]+")) {
            System.err.println("Ligne " + noLigne + ", colonne 1 ne contient pas un n\u00b0 PCR valide: " + ligne);
            return false;
        }
        if (!champs[3].matches("[0-9]+")) {
            System.err.println("Ligne " + noLigne + ", colonne 4 ne contient pas une taille amplicon valide: " + ligne);
            return false;
        }
        ProgressEvent pe = new ProgressEvent(this, noLigne, -1);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ProgressListener)it.next()).lineRead(pe);
        }
        return true;
    }

    public String toString() {
        return "{LecteurFichier: fichier=" + this.fileName + "}";
    }

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }

    static {
        $assertionsDisabled = !LecteurFichier.class.desiredAssertionStatus();
    }
}

