/*
 * Decompiled with CFR 0.152.
 */
package rfdd.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import rfdd.gui.FilePrettyfier;

public class FileBox
extends JPanel {
    private JTextField file;
    private JTextField message;
    private JButton button;
    private JFileChooser chooser = new JFileChooser(".");
    private Component parent;
    private FilePrettyfier prettyfier;
    private static String DEFAULT_BUTTON_LABEL = "Parcourir ...";
    private static String DEFAULT_MESSAGE = "Choississez un fichier";

    public FileBox(String title, Component parent, FilePrettyfier prettyfier) {
        this(title, parent, true, DEFAULT_BUTTON_LABEL, DEFAULT_MESSAGE, prettyfier);
    }

    public FileBox(String title, Component parent, boolean editable, String buttonLabel, String defaultMessage, FilePrettyfier prettyfier) {
        this.parent = parent;
        this.prettyfier = prettyfier;
        BorderLayout b = new BorderLayout();
        b.setHgap(10);
        b.setVgap(10);
        this.setLayout(b);
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.file = new JTextField(50);
        this.file.setEditable(editable);
        this.file.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.onUpdate(e.getDocument());
            }

            public void removeUpdate(DocumentEvent e) {
                this.onUpdate(e.getDocument());
            }

            public void changedUpdate(DocumentEvent e) {
                this.onUpdate(e.getDocument());
            }

            private void onUpdate(Document d) {
                try {
                    FileBox.this.pretty(new File(d.getText(0, d.getLength())));
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
        this.message = new JTextField();
        this.message.setEditable(false);
        this.message.setBorder(BorderFactory.createEmptyBorder());
        this.message.setText(defaultMessage);
        this.button = new JButton(buttonLabel);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileBox.this.chooseFile();
            }
        });
        this.add((Component)this.file, "Center");
        this.add((Component)this.button, "East");
        this.add((Component)this.message, "South");
    }

    void chooseFile() {
        if (this.chooser.showOpenDialog(this.parent) == 0) {
            File f = this.chooser.getSelectedFile();
            this.pretty(f);
            this.file.setText(this.prettyfier.getName(f));
        }
    }

    void pretty(File f) {
        this.file.setBorder(BorderFactory.createLineBorder(this.prettyfier.getColor(f)));
        this.message.setBackground(this.prettyfier.getColor(f).brighter());
        this.message.setText(this.prettyfier.getMessage(f));
    }

    public File getFile() {
        return new File(this.file.getText());
    }
}

