/*
 * Decompiled with CFR 0.152.
 */
package rfdd;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import rfdd.chainons.ChainonAppariement;
import rfdd.chainons.ChainonCalibration;
import rfdd.chainons.ChainonDebug;
import rfdd.chainons.ChainonRealigneur;
import rfdd.chainons.ChainonRecalculeProfil;
import rfdd.chainons.ChainonRecalculeTailleRef;
import rfdd.chainons.LecteurFichier;
import rfdd.chainons.Pipeline;
import rfdd.chainons.SortieFichier;

public class Main {
    public static void main(String[] args) throws IOException {
        SortieFichier sortie;
        LecteurFichier entree;
        PrintWriter stderr = new PrintWriter(System.err, true);
        if (args.length >= 1 && !"-".equals(args[0])) {
            File infile = new File(args[0]);
            stderr.println("Fichier d'entr\u00e9e: " + infile.getCanonicalPath());
            entree = new LecteurFichier(infile);
        } else {
            stderr.println("Lecture sur l'entr\u00e9e standard");
            entree = new LecteurFichier();
        }
        if (args.length >= 2 && !"-".equals(args[1])) {
            File outfile = new File(args[1]);
            stderr.println("Fichier de sortie: " + outfile.getCanonicalPath());
            sortie = new SortieFichier(outfile, "ISO-8859-1");
        } else {
            stderr.println("Ecriture sur la sortie standard");
            sortie = new SortieFichier();
        }
        Pipeline pipe = new Pipeline();
        pipe.add(entree);
        pipe.add(new ChainonRealigneur(0.25f));
        pipe.add(new ChainonRecalculeTailleRef());
        pipe.add(new ChainonCalibration(0.006f));
        pipe.add(new ChainonRecalculeProfil(0.3f));
        pipe.add(new ChainonDebug(stderr, "<"));
        pipe.add(new ChainonAppariement(0.002f));
        pipe.add(new ChainonDebug(stderr, ">"));
        pipe.add(sortie);
        stderr.println("Le pipeline est pr\u00eat: " + pipe);
        pipe.run();
    }
}

