/*
 * Decompiled with CFR 0.152.
 */
package rfdd.chainons;

import java.util.Iterator;
import rfdd.beans.GrandGroupe;
import rfdd.beans.ListeMesures;
import rfdd.beans.ListeMesures2;
import rfdd.beans.Mesure;
import rfdd.beans.PetitGroupe;
import rfdd.beans.PetitGroupe2;
import rfdd.chainons.ChainonSimple;
import rfdd.chainons.ProfilUtil;

public class ChainonAppariement
extends ChainonSimple {
    private final float precision;
    private PetitGroupe2 pgPrecedant;
    private PetitGroupe2 pgEnCours;
    private ListeMesures2 ligneEnCours;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ChainonAppariement(float precision) {
        this.precision = precision;
    }

    public void startGrandGroupe(GrandGroupe gg) {
        if (!$assertionsDisabled && this.ligneEnCours != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.pgEnCours != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.pgPrecedant != null) {
            throw new AssertionError();
        }
        super.startGrandGroupe(gg);
    }

    public void startPetitGroupe(PetitGroupe pg) {
        if (!$assertionsDisabled && this.ligneEnCours != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.pgEnCours != null) {
            throw new AssertionError();
        }
        this.pgEnCours = new PetitGroupe2(pg);
    }

    public void startLigne(ListeMesures l) {
        if (!$assertionsDisabled && this.ligneEnCours != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.pgEnCours == null) {
            throw new AssertionError();
        }
        this.ligneEnCours = new ListeMesures2(l);
    }

    public void mesure(Mesure m) {
        if (!$assertionsDisabled && this.ligneEnCours == null) {
            throw new AssertionError();
        }
        this.ligneEnCours.add(m);
    }

    public void stopLigne() {
        this.pgEnCours.add(this.ligneEnCours);
        this.ligneEnCours = null;
    }

    public void stopPetitGroupe() {
        if (this.pgPrecedant != null && (this.pgPrecedant.getTripletDebut().equals(this.pgEnCours.getTripletDebut()) && this.pgPrecedant.getTripletFin().equals(this.pgEnCours.getTripletFin()) || this.pgPrecedant.getTripletDebut().equals(this.pgEnCours.getTripletFin()) && this.pgPrecedant.getTripletFin().equals(this.pgEnCours.getTripletDebut())) && Math.abs(this.pgPrecedant.getTailleAmplicon() - this.pgEnCours.getTailleAmplicon()) <= 1) {
            this.traite2PG();
        } else {
            if (this.pgPrecedant != null) {
                this.passePG(this.pgPrecedant);
            }
            this.pgPrecedant = this.pgEnCours;
            this.pgEnCours = null;
        }
    }

    private void traite2PG() {
        if (!$assertionsDisabled && !this.pgPrecedant.getTripletDebut().equals(this.pgEnCours.getTripletDebut())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.pgPrecedant.getTripletFin().equals(this.pgEnCours.getTripletFin())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Math.abs(this.pgPrecedant.getTailleAmplicon() - this.pgEnCours.getTailleAmplicon()) > 1) {
            throw new AssertionError();
        }
        Iterator i1 = this.pgPrecedant.iterator();
        while (i1.hasNext()) {
            ListeMesures2 ligne1 = (ListeMesures2)i1.next();
            Iterator i2 = this.pgEnCours.iterator();
            while (i2.hasNext()) {
                ListeMesures2 ligne2 = (ListeMesures2)i2.next();
                if (!(Math.abs(ligne1.getTailleRef() - ligne2.getTailleRef()) <= this.precision) || !ProfilUtil.compatibles(ligne1.getProfil(), ligne2.getProfil())) continue;
                String pf = ProfilUtil.profilFiable(ligne1.getProfil(), ligne2.getProfil());
                ligne1.setProfilFiable(pf);
                ligne2.setProfilFiable(pf);
            }
        }
        this.passePG(this.pgPrecedant);
        this.passePG(this.pgEnCours);
        this.pgPrecedant = null;
        this.pgEnCours = null;
    }

    public void stopGrandGroupe() {
        if (!$assertionsDisabled && this.pgEnCours != null) {
            throw new AssertionError();
        }
        if (this.pgPrecedant != null) {
            this.passePG(this.pgPrecedant);
            this.pgPrecedant = null;
        }
        if (!$assertionsDisabled && this.pgPrecedant != null) {
            throw new AssertionError();
        }
        super.stopGrandGroupe();
    }

    private void passePG(PetitGroupe2 pg) {
        super.startPetitGroupe(new PetitGroupe(pg));
        Iterator i = pg.iterator();
        while (i.hasNext()) {
            ListeMesures2 ligne = (ListeMesures2)i.next();
            super.startLigne(new ListeMesures(ligne));
            Iterator iMesures = ligne.iterator();
            while (iMesures.hasNext()) {
                Mesure m = (Mesure)iMesures.next();
                super.mesure(m);
            }
            super.stopLigne();
        }
        super.stopPetitGroupe();
    }

    public String toString() {
        return "{ChainonAppariement: precision=" + this.precision + "}";
    }

    static {
        $assertionsDisabled = !ChainonAppariement.class.desiredAssertionStatus();
    }
}

