/*
 * Decompiled with CFR 0.152.
 */
package rfdd.chainons;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import rfdd.beans.ListeMesures;
import rfdd.beans.Mesure;
import rfdd.beans.PetitGroupe;
import rfdd.chainons.ChainonSimple;

public class ChainonRealigneur
extends ChainonSimple {
    private final float tolerance;
    private Map colonnes;

    public ChainonRealigneur(float tolerance) {
        this.tolerance = tolerance;
    }

    public void startPetitGroupe(PetitGroupe pg) {
        super.startPetitGroupe(pg);
        this.colonnes = new HashMap();
    }

    public void stopPetitGroupe() {
        while (!this.colonnes.isEmpty()) {
            ListeMesures liste = new ListeMesures();
            liste.setProfil("N/C");
            liste.setTailleRef(Float.NaN);
            super.startLigne(liste);
            float tailleMin = this.chercheTailleMin();
            this.extraitMesuresTolerees(tailleMin);
            super.stopLigne();
        }
        super.stopPetitGroupe();
    }

    private void extraitMesuresTolerees(float tailleMin) {
        Iterator it2 = new LinkedHashSet(this.colonnes.entrySet()).iterator();
        while (it2.hasNext()) {
            Map.Entry entry = (Map.Entry)it2.next();
            String colName = (String)entry.getKey();
            List colonne = (List)entry.getValue();
            Mesure m = (Mesure)colonne.get(0);
            if (!(m.getTaille() - tailleMin <= 2.0f * this.tolerance)) continue;
            super.mesure(m);
            colonne.remove(m);
            if (!colonne.isEmpty()) continue;
            this.colonnes.remove(colName);
        }
    }

    private float chercheTailleMin() {
        float tailleMin = Float.MAX_VALUE;
        Iterator it1 = this.colonnes.values().iterator();
        while (it1.hasNext()) {
            List colonne = (List)it1.next();
            Mesure m = (Mesure)colonne.get(0);
            if (!(m.getTaille() < tailleMin)) continue;
            tailleMin = m.getTaille();
        }
        return tailleMin;
    }

    public void startLigne(ListeMesures l) {
    }

    public void stopLigne() {
    }

    public void mesure(Mesure m) {
        LinkedList<Mesure> colonne = (LinkedList<Mesure>)this.colonnes.get(m.getConditions());
        if (colonne == null) {
            colonne = new LinkedList<Mesure>();
            this.colonnes.put(m.getConditions(), colonne);
        }
        colonne.add(m);
    }

    public String toString() {
        return "{Realigneur: tolerance=" + this.tolerance + "}";
    }
}

