/*
 * Decompiled with CFR 0.152.
 */
package rfdd.chainons;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import rfdd.beans.ListeMesures;
import rfdd.beans.ListeMesures2;
import rfdd.beans.Mesure;
import rfdd.chainons.ChainonSimple;

public class ChainonRecalculeProfil2
extends ChainonSimple {
    private static final Map MODE1;
    private static final Map MODE2;
    private static final Map MODE3;
    private final float seuilCodeBiChar;
    private ListeMesures2 ligneEnCours;
    private float fluo_Hp;
    private float fluo_Hm;
    private float fluo_N;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ChainonRecalculeProfil2(float seuilCodeBiChar) {
        this.seuilCodeBiChar = seuilCodeBiChar;
    }

    public void startLigne(ListeMesures l) {
        if (!$assertionsDisabled && l == null) {
            throw new AssertionError();
        }
        this.ligneEnCours = new ListeMesures2(l);
        this.fluo_Hp = 0.0f;
        this.fluo_Hm = 0.0f;
        this.fluo_N = 0.0f;
    }

    public void mesure(Mesure m) {
        if ("Hp".equals(m.getConditions())) {
            this.fluo_Hp = m.getFluo();
        } else if ("Hm".equals(m.getConditions())) {
            this.fluo_Hm = m.getFluo();
        } else if ("N".equals(m.getConditions())) {
            this.fluo_N = m.getFluo();
        }
        this.ligneEnCours.add(m);
    }

    public void stopLigne() {
        Map correspondances;
        String code;
        float max = Float.MIN_VALUE;
        if (this.fluo_Hp > max) {
            max = this.fluo_Hp;
        }
        if (this.fluo_Hm > max) {
            max = this.fluo_Hm;
        }
        if (this.fluo_N > max) {
            max = this.fluo_N;
        }
        if (this.fluo_Hp == 0.0f || this.fluo_N == 0.0f) {
            code = this.calculeCodeBichar(this.fluo_Hp / max, this.fluo_Hm / max, this.fluo_N / max);
            correspondances = MODE2;
        } else if (this.fluo_Hm == 0.0f) {
            code = this.calculeCodeTrichar(this.fluo_Hp / max, this.fluo_Hm / max, this.fluo_N / max);
            correspondances = MODE3;
        } else {
            code = this.calculeCodeBichar(this.fluo_Hp / max, this.fluo_Hm / max, this.fluo_N / max);
            correspondances = MODE1;
        }
        String[] profilsCompatibles = (String[])correspondances.get(code);
        for (int i = 0; i < profilsCompatibles.length; ++i) {
            String profil = profilsCompatibles[i];
            ListeMesures lm = new ListeMesures(this.ligneEnCours);
            lm.setProfil(profil);
            lm.setCodeBiChar(code);
            super.startLigne(lm);
            Iterator im = this.ligneEnCours.iterator();
            while (im.hasNext()) {
                super.mesure((Mesure)im.next());
            }
            super.stopLigne();
        }
        this.ligneEnCours = null;
    }

    private String calculeCodeMonochar(float mesure1, float mesure2) {
        if (!($assertionsDisabled || 0.0f <= mesure1 && mesure1 <= 1.0f)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0.0f <= mesure2 && mesure2 <= 1.0f)) {
            throw new AssertionError();
        }
        return mesure1 >= mesure2 + this.seuilCodeBiChar ? "-" : (mesure1 + this.seuilCodeBiChar <= mesure2 ? "+" : "=");
    }

    private String calculeCodeBichar(float mesure1, float mesure2, float mesure3) {
        if (!($assertionsDisabled || 0.0f <= mesure1 && mesure1 <= 1.0f)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0.0f <= mesure2 && mesure2 <= 1.0f)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0.0f <= mesure3 && mesure3 <= 1.0f)) {
            throw new AssertionError();
        }
        return this.calculeCodeMonochar(mesure1, mesure2) + this.calculeCodeMonochar(mesure2, mesure3);
    }

    private String calculeCodeTrichar(float mesure1, float mesure2, float mesure3) {
        if (!($assertionsDisabled || 0.0f <= mesure1 && mesure1 <= 1.0f)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0.0f <= mesure2 && mesure2 <= 1.0f)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0.0f <= mesure3 && mesure3 <= 1.0f)) {
            throw new AssertionError();
        }
        return this.calculeCodeBichar(mesure1, mesure2, mesure3) + "(" + this.calculeCodeMonochar(mesure1, mesure3) + ")";
    }

    public String toString() {
        return "{RecalculeProfil2: seuil=" + this.seuilCodeBiChar + "}";
    }

    private static Map getTableauMode1() {
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        m.put("--", new String[]{"Activ\u00e9 par l'hypoxie"});
        m.put("-=", new String[]{"Activ\u00e9 par l'hypoxie", "(Inhib\u00e9 par l'hypoxie moyenne)", "(Non modifi\u00e9 par O2)"});
        m.put("-+", new String[]{"Inhib\u00e9 par l'hypoxie moyenne"});
        m.put("=-", new String[]{"Activ\u00e9 par l'hypoxie moyenne", "(Non modifi\u00e9 par O2)", "(Activ\u00e9 par l'hypoxie)"});
        m.put("==", new String[]{"Non modifi\u00e9 par O2"});
        m.put("=+", new String[]{"(Inhib\u00e9 par l'hypoxie moyenne)", "Activ\u00e9 par la normoxie", "(Non modifi\u00e9 par O2)"});
        m.put("+-", new String[]{"Activ\u00e9 par l'hypoxie moyenne"});
        m.put("+=", new String[]{"(Activ\u00e9 par la normoxie)", "(Non modifi\u00e9 par O2)", "Activ\u00e9 par l'hypoxie moyenne"});
        m.put("++", new String[]{"Activ\u00e9 par la normoxie"});
        return Collections.unmodifiableMap(m);
    }

    private static Map getTableauMode2() {
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        m.put("--", new String[]{"Activ\u00e9 par l'hypoxie"});
        m.put("-=", new String[]{"Activ\u00e9 par l'hypoxie"});
        m.put("-+", new String[]{"Inhib\u00e9 par l'hypoxie moyenne"});
        m.put("=-", new String[]{"Activ\u00e9 par l'hypoxie moyenne"});
        m.put("==", new String[]{"Non modifi\u00e9 par O2"});
        m.put("=+", new String[]{"Activ\u00e9 par la normoxie"});
        m.put("+-", new String[]{"Activ\u00e9 par l'hypoxie moyenne"});
        m.put("+=", new String[]{"Activ\u00e9 par l'hypoxie moyenne"});
        m.put("++", new String[]{"Activ\u00e9 par la normoxie"});
        return Collections.unmodifiableMap(m);
    }

    private static Map getTableauMode3() {
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        m.put("-+(-)", new String[]{"Inhib\u00e9 par l'hypoxie moyenne", "(Activ\u00e9 par l'hypoxie)"});
        m.put("-+(=)", new String[]{"Inhib\u00e9 par l'hypoxie moyenne"});
        m.put("-+(+)", new String[]{"Inhib\u00e9 par l'hypoxie moyenne", "(Activ\u00e9 par la normoxie)"});
        m.put("-=(-)", new String[]{"Activ\u00e9 par l'hypoxie"});
        m.put("-=(=)", new String[]{"Activ\u00e9 par l'hypoxie"});
        m.put("-=(+)", new String[]{"cas impossible"});
        m.put("-+(+)", new String[]{"Inhib\u00e9 par l'hypoxie moyenne", "(Activ\u00e9 par la normoxie)"});
        m.put("=+(+)", new String[]{"Activ\u00e9 par la normoxie"});
        m.put("=+(=)", new String[]{"Non modifi\u00e9 par O2"});
        return Collections.unmodifiableMap(m);
    }

    static {
        $assertionsDisabled = !ChainonRecalculeProfil2.class.desiredAssertionStatus();
        MODE1 = ChainonRecalculeProfil2.getTableauMode1();
        MODE2 = ChainonRecalculeProfil2.getTableauMode2();
        MODE3 = ChainonRecalculeProfil2.getTableauMode3();
    }
}

