/*
 * Decompiled with CFR 0.152.
 */
package rfdd.chainons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rfdd.chainons.Chainon;
import rfdd.chainons.LecteurFichier;
import rfdd.chainons.SortieFichier;
import rfdd.gui.evt.ProgressEvent;
import rfdd.gui.evt.ProgressListener;

public class Pipeline {
    private List chainons = new LinkedList();
    private List listeners = new ArrayList();

    public void add(Chainon c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c instanceof LecteurFichier) {
            LecteurFichier lf = (LecteurFichier)c;
            lf.addProgressListener(new ProgressListener(){

                public void lineRead(ProgressEvent pe) {
                    Iterator it = Pipeline.this.listeners.iterator();
                    while (it.hasNext()) {
                        ((ProgressListener)it.next()).lineRead(pe);
                    }
                }

                public void lineWritten(ProgressEvent pe) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        if (c instanceof SortieFichier) {
            SortieFichier sf = (SortieFichier)c;
            sf.addProgressListener(new ProgressListener(){

                public void lineRead(ProgressEvent pe) {
                    throw new UnsupportedOperationException();
                }

                public void lineWritten(ProgressEvent pe) {
                    Iterator it = Pipeline.this.listeners.iterator();
                    while (it.hasNext()) {
                        ((ProgressListener)it.next()).lineWritten(pe);
                    }
                }
            });
        }
        this.chainons.add(c);
    }

    public void run() throws IOException {
        LecteurFichier lf;
        if (this.chainons.size() < 2) {
            throw new IllegalStateException("Pas assez de Chainons dans le pipeline");
        }
        Iterator i = this.chainons.iterator();
        Chainon courant = lf = (LecteurFichier)i.next();
        while (i.hasNext()) {
            Chainon suivant = (Chainon)i.next();
            courant.linkTo(suivant);
            courant = suivant;
        }
        lf.lire();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{Pipeline: ");
        Iterator i = this.chainons.iterator();
        sb.append(i.next());
        while (i.hasNext()) {
            sb.append(", ").append(i.next());
        }
        sb.append("}");
        return sb.toString();
    }

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }
}

