/*
 * Decompiled with CFR 0.152.
 */
package rfdd.chainons;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import rfdd.beans.GrandGroupe;
import rfdd.beans.ListeMesures;
import rfdd.beans.Mesure;
import rfdd.beans.PetitGroupe;
import rfdd.chainons.Chainon;
import rfdd.chainons.ChainonSimple;
import rfdd.gui.evt.ProgressEvent;
import rfdd.gui.evt.ProgressListener;

public class SortieFichier
extends ChainonSimple {
    private final PrintWriter out;
    private PetitGroupe pg;
    private GrandGroupe gg;
    private String[] ligneTexte;
    private String fileName = "N/C";
    private int lines = 0;
    private NumberFormat nf = NumberFormat.getInstance(Locale.FRANCE);
    private List listeners = new ArrayList();

    public SortieFichier(File file, String charset) throws IOException {
        this(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset), true));
        this.fileName = file.getPath();
    }

    public SortieFichier() {
        this(new PrintWriter(System.out, true));
        this.fileName = "<stdout>";
    }

    private SortieFichier(PrintWriter out) {
        this.out = out;
        this.ligneTexte = new String[23];
    }

    public void stopFichier() {
        this.out.flush();
        this.out.close();
    }

    public void startLigne(ListeMesures fragment) {
        this.ligneTexte[0] = this.nf.format(this.pg.getNoPCR());
        this.ligneTexte[1] = this.pg.getAmorce();
        this.ligneTexte[2] = this.nf.format(fragment.getTailleRef());
        this.ligneTexte[3] = this.nf.format(this.pg.getTailleAmplicon());
        this.ligneTexte[4] = "0";
        this.ligneTexte[5] = "0";
        this.ligneTexte[6] = "0";
        this.ligneTexte[7] = "0";
        this.ligneTexte[8] = "0";
        this.ligneTexte[9] = "0";
        this.ligneTexte[10] = fragment.getCodeBiChar();
        this.ligneTexte[11] = fragment.getProfil();
        this.ligneTexte[12] = fragment.getProfilFiable();
        this.ligneTexte[13] = this.gg.getProfilMajoritaire();
        this.ligneTexte[14] = this.gg.getNoGenBank();
        this.ligneTexte[15] = this.gg.getGene();
        this.ligneTexte[16] = this.gg.getProduct();
        this.ligneTexte[17] = this.gg.getRedondance();
        this.ligneTexte[18] = this.pg.getTripletDebut();
        this.ligneTexte[19] = this.pg.getTripletFin();
        this.ligneTexte[20] = this.gg.getRun();
        this.ligneTexte[21] = fragment.getProfilEnClair();
        this.ligneTexte[22] = this.pg.getEnzyme();
    }

    public void stopLigne() {
        this.out.print(this.ligneTexte[0]);
        for (int i = 1; i < this.ligneTexte.length; ++i) {
            this.out.print("\t");
            this.out.print(this.ligneTexte[i] != null ? this.ligneTexte[i] : "");
        }
        this.out.println();
        ++this.lines;
        Iterator it = this.listeners.iterator();
        ProgressEvent pe = new ProgressEvent(this, -1, this.lines);
        while (it.hasNext()) {
            ((ProgressListener)it.next()).lineWritten(pe);
        }
    }

    public void mesure(Mesure m) {
        if ("Hp".equals(m.getConditions())) {
            this.ligneTexte[4] = this.nf.format(m.getTaille());
            this.ligneTexte[7] = this.nf.format(m.getFluo());
        } else if ("Hm".equals(m.getConditions())) {
            this.ligneTexte[5] = this.nf.format(m.getTaille());
            this.ligneTexte[8] = this.nf.format(m.getFluo());
        } else if ("N".equals(m.getConditions())) {
            this.ligneTexte[6] = this.nf.format(m.getTaille());
            this.ligneTexte[9] = this.nf.format(m.getFluo());
        }
    }

    public void linkTo(Chainon c) {
        throw new UnsupportedOperationException("Impossible de chainer SortieFichier avec un autre chainon, SortieFichier est un chainon final.");
    }

    public String toString() {
        return "{SortieFichier: fichier=" + this.fileName + "}";
    }

    public void startFichier(String fileName) {
        this.ligneTexte[0] = "n\u00b0PCR";
        this.ligneTexte[1] = "amorce";
        this.ligneTexte[2] = "taille-r\u00e9f";
        this.ligneTexte[3] = "taille-amplicon";
        this.ligneTexte[4] = "taille_Hp";
        this.ligneTexte[5] = "taille_Hm";
        this.ligneTexte[6] = "taille_N";
        this.ligneTexte[7] = "fluo_Hp";
        this.ligneTexte[8] = "fluo_Hm";
        this.ligneTexte[9] = "fluo_N";
        this.ligneTexte[10] = "bichar";
        this.ligneTexte[11] = "profil";
        this.ligneTexte[12] = "fiable";
        this.ligneTexte[13] = "majoritaire";
        this.ligneTexte[14] = "n\u00b0GeneBank";
        this.ligneTexte[15] = "gene";
        this.ligneTexte[16] = "product";
        this.ligneTexte[17] = "redondance";
        this.ligneTexte[18] = "triplet-d\u00e9but";
        this.ligneTexte[19] = "triplet-fin";
        this.ligneTexte[20] = "run";
        this.ligneTexte[21] = "profil en clair";
        this.ligneTexte[22] = "enzyme";
        this.out.print(this.ligneTexte[0]);
        for (int i = 1; i < this.ligneTexte.length; ++i) {
            this.out.print("\t");
            this.out.print(this.ligneTexte[i]);
        }
        this.out.println();
        this.lines = 1;
    }

    public void startGrandGroupe(GrandGroupe gg) {
        this.gg = gg;
    }

    public void startPetitGroupe(PetitGroupe pg) {
        this.pg = pg;
    }

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }
}

