#!/usr/bin/awk -f 

BEGIN {
  tolerence=0.5;
  
  grandgroupe_encours="";
  petitgroupe_encours="";
}

$1 <= 64 && $1 >= 1 {
#ne tient compte que des lignes dont la premiere colonne contient un num PCR
# (elimine les lignes vides et les entetes de colonne)

  if (grandgroupe_encours != $12) { #si on est sur la premiere ligne d'un grand groupe
    grandgroupe_encours=$12;

    # initialise les variables constantes sur un grand groupe
    # gg_ prefixe pour grand groupe
    gg_amorce=$2;
    gg_no_genebank=$12;
    gg_gene=$13;
    gg_product=$14;
    gg_redondance=$15;
    gg_triplet_debut=$16;
    gg_triplet_fin=$17;
    gg_run=$18;
    gg_enzyme=$20;

    #remet a zero les variables constantes sur un petit groupe
    petitgroupe_encours="";
    pg_no_pcr=0;
    
  }

  if (petitgroupe_encours != $4) { #si on est sur le premiere ligne d'un petit groupe

    #comme on vient de finir un petit groupe, on s'occupe de le realigner avant de passer au suivant
    #fini de realigner, on peut lire le groupe suivant

    
    #On peut passer au suivant
    petitgroupe_encours=$4;

    #initialise les variables constantes sur un petit groupe
    # NB: pg_ prefixe pour petit groupe
    pg_no_pcr=$1;

    #variables utilisees par un petit groupe
    nblignes["Hp"]=0;
    nblignes["Hm"]=0;
    nblignes["N"]=0;
  }

  #lit les mesures de la ligne en cours et les empile dans des tableaux
  if ($5 != 0) {
    taille["Hp", nblignes["Hp"]] = $5;
    fluo["Hp", nblignes["Hp"]] = $8;
    nblignes["Hp"] += 1;
  }
  if ($6 != 0) {
    taille["Hm", nblignes["Hm"]] = $6;
    fluo["Hm", nblignes["Hm"]] = $9;
    nblignes["Hm"]+=1;
  }
  if ($7 != 0) {
    taille["N", nblignes["N"]] = $7;
    fluo["N", nblignes["N"]] = $10;
    nblignes["N"] += 1;
  }

}


function realigne() {
  
#indices de parcours des trois tableaux
  indice["Hp"]=0;
  indice["Hm"]=0;
  indice["N"]=0;
  
#variables utilisees pour la ligne a afficher
  l_taille_Hp = 0;
  l_taille_Hm = 0;
  l_taille_N = 0;
  l_fluo_Hp = 0;
  l_fluo_Hm = 0;
  l_fluo_N = 0;
  
  while (indice["Hp"]<nblignes["Hp"] || indice["Hm"]<nblignes["Hm"] || indice["N"]<nblignes["N"]) {
#tant qu'on a pas utilise toutes les valeurs
    
#constituer une ligne
    construitligne();
    
    l_taille_Hp = ligne_sortie["Hp"];
    l_fluo_Hp = "non implemente";
    l_taille_Hm = ligne_sortie["Hm"];
    l_fluo_Hm = "non implemente";
    l_taille_N = ligne_sortie["N"];
    l_fluo_N = "non implemente";
    
# recalculer les valeurs recalculees
    taille_ref = "non implemente";
    profil = "non implemente";
    
    # imprimer cette ligne
    print pg_no_pcr, gg_amorce, taille_ref, petitgroupe_encours, l_taille_Hp, l_taille_Hm, l_taille_N, l_fluo_Hp, l_fluo_Hm, l_fluo_N, profil, gg_no_genebank, gg_gene, gg_product, gg_redondance, gg_triplet_debut, gg_triplet_fin, gg_run, gg_enzyme;
    
    }
}


function construitligne() {
#variables locales
  liste_min = "";
  taille_min = 0;

#cherche la liste dont la valeur est minimum
  liste_min = "Hp"; #une liste au pif, c'est pas important
  taille_min = taille[liste_min, indice[liste_min]];
  
  for (liste in indice) {
    if (taille[liste, indice[liste]] < taille_min) {
      liste_min = liste;
      taille_min = taille[liste_min, indice[liste_min]];
    }
  }
  
#extrait la valeur et la copie dans la ligne de sortie
  ligne_sortie[liste_min] = taille_min;
  indice[liste_min] += 1;
  
#cherche dans les autres listes celles dont la taille est acceptable
  for (liste in indice) {
    if (liste = liste_min)
      continue;
    
    if (taille[liste, indice[liste]] - taille_min < 2*tolerence) {
#extrait la valeur et la copie dans la ligne de sortie
      ligne_sortie[liste] = taille[liste, indice[liste]];
      indice[liste] += 1;
    }
    else {
      ligne_sortie[liste] = 0;
    }
  }
}
