package rfdd.chainons;

import java.io.PrintWriter;

import rfdd.beans.GrandGroupe;
import rfdd.beans.ListeMesures;
import rfdd.beans.Mesure;
import rfdd.beans.PetitGroupe;

/**
 * Affiche des messages de debug et passe les évènements 
 * au <code>Chainon</code> suivant sans les traiter.
 *  
 * @author tnguyen
 * 
 */
public class ChainonDebug extends ChainonSimple
{
	private static final int FI = 1;
	private static final int FO = 2;
	private static final int GGI = 3;
	private static final int GGO = 4;
	private static final int PGI = 5;
	private static final int PGO = 6;
	private static final int LI = 7;
	private static final int LO = 8;
	private static final int M = 9;

	private int previousCall = 0;

	/**
	 * Caractère à utiliser pour indenter les messages.
	 * 
	 * <p>La tabulation ou l'espace sont de bonnes valeurs pour ce paramètre. 
	 */
	private final String tab;

	private final PrintWriter err;

	/**
	 * Constructeur.
	 * 
	 * @param err le flux de sortie sur lequel afficher les messages.
	 * @param tab le caratère de tabulation à utiliser
	 */
	public ChainonDebug(PrintWriter err, String tab)
	{
		this.err = err;
		this.err.println("using ChainonDebug");
		this.tab = tab;
	}

	public void startFichier(String fileName)
	{
		if (this.previousCall != 0)
			throw new IllegalStateException();
		this.previousCall = FI;

		this.err.println(tab + " start {Fichier: " + fileName + "}");
		super.startFichier(fileName);
	}

	public void stopFichier()
	{
		if (this.previousCall != GGO && this.previousCall != FI)
			throw new IllegalStateException();
		this.previousCall = FO;

		super.stopFichier();
		this.err.println(tab + " stop {Fichier}");
	}

	public void startGrandGroupe(GrandGroupe gg)
	{
		if (this.previousCall != FI && this.previousCall != GGO)
			throw new IllegalStateException();
		this.previousCall = GGI;

		this.err.println(tab + tab + " start " + gg);
		super.startGrandGroupe(gg);
	}

	public void stopGrandGroupe()
	{
		if (this.previousCall != GGI && this.previousCall != PGO)
			throw new IllegalStateException();
		this.previousCall = GGO;

		super.stopGrandGroupe();
		this.err.println(tab + tab + " stop  {GrandGroupe}");
	}

	public void startPetitGroupe(PetitGroupe pg)
	{
		if (this.previousCall != GGI && this.previousCall != PGO)
			throw new IllegalStateException();
		this.previousCall = PGI;

		this.err.println(tab + tab + tab + " start " + pg);
		super.startPetitGroupe(pg);
	}

	public void stopPetitGroupe()
	{
		if (this.previousCall != LO && this.previousCall != PGI)
			throw new IllegalStateException();
		this.previousCall = PGO;

		super.stopPetitGroupe();
		this.err.println(tab + tab + tab + " stop  {PetitGroupe}");
	}

	public void startLigne(ListeMesures l)
	{
		if (this.previousCall != LO && this.previousCall != PGI)
			throw new IllegalStateException();
		this.previousCall = LI;

		this.err.println(tab + tab + tab + tab + " start " + l);
		super.startLigne(l);
	}

	public void stopLigne()
	{
		if (this.previousCall != LI && this.previousCall != M)
			throw new IllegalStateException();
		this.previousCall = LO;

		super.stopLigne();
		this.err.println(tab + tab + tab + tab + " stop  {ListeMesures}");
	}

	public void mesure(Mesure m)
	{
		if (this.previousCall != LI && this.previousCall != M)
			throw new IllegalStateException();
		this.previousCall = M;

		this.err.println(tab + tab + tab + tab + tab + " start " + m);
		super.mesure(m);
	}

	public String toString()
	{
		return "{Debug: prefix=" + tab + "}";
	}

}
