/*
 * Created on Jun 2, 2004 by tnguyen
 */
package rfdd.chainons;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import rfdd.beans.GrandGroupe;
import rfdd.beans.ListeMesures;

/**
 *  
 */
public class ChainonProfilEnClair extends ChainonSimple
{
	/**
	 * Le <code>GrandGroupe</code> en cours.
	 */
	private GrandGroupe gg;

	private static final Map TRADUC = new HashMap();
	static
	{
		TRADUC.put(new Character('/'), "activé par la Normoxie");
		TRADUC.put(new Character('-'), "Non modifié");
		TRADUC.put(new Character('\\'), "activé par l'Hypoxie");
		TRADUC.put(new Character('A'), "activé par l'hypoxie Moyenne");
		TRADUC.put(new Character('V'), "Inhibé par l'hypoxie Moyenne");
	}

	public void startGrandGroupe(GrandGroupe gg)
	{
		this.gg = gg;

		super.startGrandGroupe(gg);
	}

	public void startLigne(ListeMesures l)
	{
		String profil = "";
		String fiable = l.getProfilFiable();
		String majo = gg.getProfilMajoritaire();

		List profils = ProfilUtil.asList((fiable != null && !fiable.equals("")) ? fiable
				: ((majo != null && !majo.equals("")) ? majo : ""));

		if (profils.size() > 0)
		{
			profil = (String) TRADUC.get(profils.get(0));
		}
		l.setProfilEnClair(profil);

		super.startLigne(l);
	}
}