/*
 * Created on Apr 4, 2004
 */
package rfdd.chainons;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import rfdd.beans.ListeMesures;
import rfdd.beans.Mesure;


/**
 * Recalcule la taille de référence.
 * 
 * <p>Moyenne des tailles expérimentales.
 * 
 * @author tnguyen
 */
public class ChainonRecalculeTailleRef extends ChainonSimple
{
	/**
	 * Variable temporaire utilisée pour le calcul de la moyenne.
	 */
	private float somme;
	
	private ListeMesures ligneEnCours;

	/**
	 * Stocke les mesures en atteandant d'avoir calculé la moyenne.
	 */
	private List mesures = new LinkedList();

	public void startLigne(ListeMesures l)
	{
		this.ligneEnCours=l;
		this.mesures.clear();
		this.somme = 0f;
	}

	public void mesure(Mesure m)
	{
		//accumule des tailles
		this.somme += m.getTaille();

		//stocke les mesures
		this.mesures.add(m);
	}

	public void stopLigne()
	{
		//calcule la moyenne
		float moy = this.somme / this.mesures.size();

		//modifie la taille de ref
		this.ligneEnCours.setTailleRef(moy);

		super.startLigne(this.ligneEnCours);

		// "libère" toutes les mesures mémorisées
		Iterator i = this.mesures.iterator();
		while (i.hasNext())
		{
			super.mesure((Mesure) i.next());
		}
		//this.mesures.clear();

		super.stopLigne();
		this.ligneEnCours=null;
	}

	public String toString()
	{
		return "{RecalculeTailleRef}";
	}

}