/*
 * Created on Apr 3, 2004
 */
package rfdd.chainons;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import rfdd.beans.GrandGroupe;
import rfdd.beans.ListeMesures;
import rfdd.beans.Mesure;
import rfdd.beans.PetitGroupe;
import rfdd.gui.evt.ProgressEvent;
import rfdd.gui.evt.ProgressListener;

/**
 * Lit un fichier, et l'injecte dans le premier chainon de traitement.
 * 
 * TODO documenter le format du fichier en entrée
 * 
 * @author tnguyen
 */
public class LecteurFichier extends ChainonSimple
{
	private String fileName = "N/C";

	private LineNumberReader in;

	/**
	 * Construit un <code>LecteurFichier</code> qui prends ses données dans
	 * l'entrée stadard.
	 */
	public LecteurFichier()
	{
		this(new InputStreamReader(System.in));
		this.fileName = "<stdin>";
	}

	/**
	 * Construit un <code>LecteurFichier</code> qui prends ses données dans un
	 * fichier.
	 * 
	 * @param f le fichier en entrée
	 */
	public LecteurFichier(File f) throws FileNotFoundException
	{
		this(new FileReader(f));
		this.fileName = f.getPath();
	}

	/**
	 * Construit un <code>LecteurFichier</code> qui prends ses données dans
	 * flux de caractères.
	 * 
	 * @param input
	 */
	private LecteurFichier(Reader input)
	{
		// bufferise l'entrée et compte les lignes
		this.in = new LineNumberReader(input);
	}

	public void lire() throws IOException
	{
		//
		// start Fichier
		//
		startFichier(this.fileName);

		//
		// lit la première ligne
		//
		String[] champs = getNextLine();

		//
		// itère sur les grands groupes d'un même fichier
		//
		while (champs != null)
		{
			int noPCR = Integer.parseInt(champs[0]);
			String amorce = champs[1];
			float tailleRef = parseFloat(champs[2]);
			int tailleAmplicon = Integer.parseInt(champs[3]);
			float taille_Hp = parseFloat(champs[4]);
			float taille_Hm = parseFloat(champs[5]);
			float taille_N = parseFloat(champs[6]);
			float fluo_Hp = parseFloat(champs[7]);
			float fluo_Hm = parseFloat(champs[8]);
			float fluo_N = parseFloat(champs[9]);
			String profil = champs[10];
			String noGenBank = champs[11].trim();
			String gene = champs[12];
			String product = champs[13];
			String redondance = champs[14];
			String tripletDebut = champs[15];
			String tripletFin = champs[16];
			String run = champs[17];
			String commentaire = champs[18];
			String enzyme = champs[19];

			//
			// grand groupe
			//
			GrandGroupe gg = new GrandGroupe();

			gg.setNoGenBank(noGenBank);
			gg.setGene(gene);
			gg.setProduct(product);
			gg.setRedondance(redondance);
			gg.setRun(run);

			startGrandGroupe(gg);

			//
			// itère sur les petits groupes d'un même grand groupe
			//
			while (noGenBank.equals(gg.getNoGenBank()) && champs != null)
			{
				assert noGenBank.equals(gg.getNoGenBank());
				assert gene.equals(gg.getGene());
				assert product.equals(gg.getProduct());
				assert redondance.equals(gg.getRedondance());
				assert run.equals(gg.getRun());

				//
				// petit groupe
				//
				PetitGroupe pg = new PetitGroupe();

				pg.setTailleAmplicon(tailleAmplicon);
				pg.setNoPCR(noPCR);
				pg.setEnzyme(enzyme);
				pg.setAmorce(amorce);
				pg.setTripletDebut(tripletDebut);
				pg.setTripletFin(tripletFin);

				startPetitGroupe(pg);

				//
				// itère sur les lignes d'un même petit groupe
				//
				while (pg.getTailleAmplicon() == tailleAmplicon
						&& pg.getNoPCR() == noPCR
						&& pg.getEnzyme().equals(enzyme) && champs != null)
				{
					assert tailleAmplicon == pg.getTailleAmplicon();
					assert noPCR == pg.getNoPCR();
					assert enzyme.equals(pg.getEnzyme());
					assert amorce.equals(pg.getAmorce());
					assert tripletDebut.equals(pg.getTripletDebut());
					assert tripletFin.equals(pg.getTripletFin());

					//
					// liste de mesures
					//
					ListeMesures lm = new ListeMesures();

					lm.setProfil(profil);
					lm.setTailleRef(tailleRef);

					startLigne(lm);

					if (taille_Hp != 0.0)
							mesure(new Mesure(taille_Hp, fluo_Hp, "Hp"));

					if (taille_Hm != 0.0)
							mesure(new Mesure(taille_Hm, fluo_Hm, "Hm"));

					if (taille_N != 0.0)
							mesure(new Mesure(taille_N, fluo_N, "N"));

					stopLigne();

					//
					// lit la ligne suivante
					//
					champs = getNextLine();

					if (champs != null)
					{
						//System.err.println("n° ligne: " +
						// this.in.getLineNumber());
						noPCR = Integer.parseInt(champs[0]);
						amorce = champs[1];
						tailleRef = parseFloat(champs[2]);
						tailleAmplicon = Integer.parseInt(champs[3]);
						taille_Hp = parseFloat(champs[4]);
						taille_Hm = parseFloat(champs[5]);
						taille_N = parseFloat(champs[6]);
						fluo_Hp = parseFloat(champs[7]);
						fluo_Hm = parseFloat(champs[8]);
						fluo_N = parseFloat(champs[9]);
						profil = champs[10];
						noGenBank = champs[11].trim();
						gene = champs[12];
						product = champs[13];
						redondance = champs[14];
						tripletDebut = champs[15];
						tripletFin = champs[16];
						run = champs[17];
						commentaire = champs[18];
						enzyme = champs[19];
					}

				} // end - while (pg.getTailleAmplicon() == tailleAmplicon &&
				// pg.getNoPCR() == noPCR)

				stopPetitGroupe();

			} // end - while (noGenBank.equals(gg.getNoGenBank()))

			stopGrandGroupe();

		} // end - while (ligne != null)

		stopFichier();

	} // end - public void lire2()

	/**
	 * Retourne la ligne valide suivante. Les lignes invalides (par ex: les
	 * entêtes de colonne) sont simplement ignorées.
	 * 
	 * @return un tableau de <code>String</code> représentant les cellules
	 *         d'une ligne ou <code>null</code> si le fichier est terminé.
	 * 
	 * @throws IOException
	 */
	private String[] getNextLine() throws IOException
	{
		String ligne = this.in.readLine();

		while (ligne != null && !valide(ligne, this.in.getLineNumber()))
		{
			ligne = this.in.readLine();
		}
		return (ligne == null) ? null : ligne.split("\t");
	}

	/**
	 * Petite méthode utilitaire pour lire les nombre décimaux séparés par une
	 * virgule au lieu d'un point
	 * 
	 * @param s représentation textuelle d'un nombre décimal
	 * @return le float
	 */
	private static float parseFloat(String s)
	{
		return Float.parseFloat(s.replace(',', '.'));
	}

	private boolean valide(String ligne, int noLigne)
	{
		String[] champs = ligne.split("\t");
		if (champs.length < 20)
		{
			System.err.println("Ligne " + noLigne + " ne contient que"
					+ champs.length + "colonnes: " + ligne);
			return false;
		}

		if (!champs[0].matches("[0-9]+"))
		{
			System.err.println("Ligne " + noLigne
					+ ", colonne 1 ne contient pas un n° PCR valide: " + ligne);
			return false;
		}

		if (!champs[3].matches("[0-9]+"))
		{
			System.err
					.println("Ligne "
							+ noLigne
							+ ", colonne 4 ne contient pas une taille amplicon valide: "
							+ ligne);
			return false;
		}

		// si la ligne est valide, on notifie les listeners
		ProgressEvent pe = new ProgressEvent(this, noLigne, -1);
		Iterator it = this.listeners.iterator();
		while (it.hasNext())
		{
			((ProgressListener) it.next()).lineRead(pe);
		}

		return true;
	}

	public String toString()
	{
		return "{LecteurFichier: fichier=" + this.fileName + "}";
	}

	private List listeners = new ArrayList();

	public void addProgressListener(ProgressListener pl)
	{
		this.listeners.add(pl);
	}

	public void removeProgressListener(ProgressListener pl)
	{
		this.listeners.remove(pl);
	}

}