/*
 * Created on Apr 12, 2004
 *  
 */
package rfdd.chainons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import rfdd.gui.evt.ProgressEvent;
import rfdd.gui.evt.ProgressListener;

/**
 * @author tnguyen
 *  
 */
public class Pipeline
{
	private List chainons = new LinkedList();

	public void add(Chainon c)
	{
		if (c == null) throw new NullPointerException();

		if (c instanceof LecteurFichier)
		{
			LecteurFichier lf = (LecteurFichier) c;
			lf.addProgressListener(new ProgressListener()
			{
				public void lineRead(ProgressEvent pe)
				{
					Iterator it = listeners.iterator();
					while (it.hasNext())
					{
						((ProgressListener) it.next()).lineRead(pe);
					}
				}

				public void lineWritten(ProgressEvent pe)
				{
					throw new UnsupportedOperationException();
				}
			});
		}

		if (c instanceof SortieFichier)
		{
			SortieFichier sf = (SortieFichier) c;
			sf.addProgressListener(new ProgressListener()
			{
				public void lineRead(ProgressEvent pe)
				{
					throw new UnsupportedOperationException();
				}

				public void lineWritten(ProgressEvent pe)
				{
					Iterator it = listeners.iterator();
					while (it.hasNext())
					{
						((ProgressListener) it.next()).lineWritten(pe);
					}
				}
			});
		}

		this.chainons.add(c);
	}

	public void run() throws IOException
	{
		if (this.chainons.size() < 2)
				throw new IllegalStateException(
						"Pas assez de Chainons dans le pipeline");

		// fait les liens entre chainons
		Iterator i = this.chainons.iterator();
		LecteurFichier lf = (LecteurFichier) i.next();
		Chainon courant = lf;
		while (i.hasNext())
		{
			Chainon suivant = (Chainon) i.next();
			courant.linkTo(suivant);
			courant = suivant;
		}

		// exécute les traitements
		lf.lire();
	}

	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("{Pipeline: ");

		Iterator i = this.chainons.iterator();
		sb.append(i.next());
		while (i.hasNext())
			sb.append(", ").append(i.next());

		sb.append("}");
		return sb.toString();
	}

	private List listeners = new ArrayList();

	public void addProgressListener(ProgressListener pl)
	{
		this.listeners.add(pl);
	}

	public void removeProgressListener(ProgressListener pl)
	{
		this.listeners.remove(pl);
	}

}