/*
 * Created on Apr 15, 2004
 *  
 */
package rfdd.gui;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import rfdd.GUI;
import rfdd.chainons.Pipeline;

/**
 * @author tnguyen
 *  
 */
public class ExecutePipelineAction extends AbstractAction implements Runnable
{
	private ProgressDialog dialog;

	private Pipeline pipeline;
	private GUI gui;

	public ExecutePipelineAction(GUI gui)
	{
		super("Démarrer");
		this.gui = gui;
	}

	public void actionPerformed(ActionEvent e)
	{
		try
		{
			this.pipeline = this.gui.buildPipeline();
			System.err.println(this.pipeline);

			dialog = new ProgressDialog(this.gui);
			this.pipeline.addProgressListener(dialog);

			this.setEnabled(false);
			dialog.pack();

			new Thread(this).start();

			dialog.setVisible(true);
		}
		catch (BadParamException bpe)
		{
			JOptionPane.showMessageDialog(this.gui, bpe.getLocalizedMessage(),
					"Erreur de lecture du fichier", JOptionPane.ERROR_MESSAGE);
		}
	}

	public void run()
	{
		try
		{
			this.pipeline.run();

			SwingUtilities.invokeLater(new Runnable()
			{
				public void run()
				{
					dialog.setInfo("Traitement terminé avec succès");
				}
			});
		}
		catch (Exception e)
		{
			e.printStackTrace(System.err);

			SwingUtilities.invokeLater(new Runnable()
			{
				public void run()
				{
					dialog.setInfo("Erreur pendant le traitement");

				}
			});
		}
		finally
		{
			SwingUtilities.invokeLater(new Runnable()
			{
				public void run()
				{
					dialog.allowClose();
					ExecutePipelineAction.this.setEnabled(true);
				}
			});
		}
	}
}