/*
 * Created on Apr 5, 2004
 */

package rfdd.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

/**
 * @author tnguyen
 *
 */
public class FileBox extends JPanel
{
	private JTextField file;
	private JTextField message;
	private JButton button;
	private JFileChooser chooser = new JFileChooser(".");
	private Component parent;
	private FilePrettyfier prettyfier;

	private static String DEFAULT_BUTTON_LABEL = "Parcourir ...";
	private static String DEFAULT_MESSAGE = "Choississez un fichier";

	public FileBox(String title, Component parent, FilePrettyfier prettyfier)
	{
		this(title, parent, true, DEFAULT_BUTTON_LABEL, DEFAULT_MESSAGE, prettyfier);
	}

	public FileBox(
		String title,
		Component parent,
		boolean editable,
		String buttonLabel,
		String defaultMessage,
		FilePrettyfier prettyfier)
	{
		//composant parent
		this.parent = parent;

		// le composant qui décide de la couleur et du message d'erreur
		this.prettyfier = prettyfier;

		// bordures
		BorderLayout b = new BorderLayout();
		b.setHgap(10);
		b.setVgap(10);
		setLayout(b);
		setBorder(BorderFactory.createTitledBorder(title));

		// affichage du nom du fichier
		this.file = new JTextField(50);
		this.file.setEditable(editable);
		this.file.getDocument().addDocumentListener(new DocumentListener()
		{
			public void insertUpdate(DocumentEvent e)
			{
				onUpdate(e.getDocument());
			}
			public void removeUpdate(DocumentEvent e)
			{
				onUpdate(e.getDocument());
			}
			public void changedUpdate(DocumentEvent e)
			{
				onUpdate(e.getDocument());
			}
			private void onUpdate(Document d)
			{
				try
				{
					pretty(new File(d.getText(0, d.getLength())));
				}
				catch (BadLocationException e)
				{
					e.printStackTrace();
				}
			}
		});

		// message d'état
		this.message = new JTextField();
		this.message.setEditable(false);
		this.message.setBorder(BorderFactory.createEmptyBorder());
		this.message.setText(defaultMessage);

		// bouton pour parcourir les fichiers
		this.button = new JButton(buttonLabel);
		this.button.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				chooseFile();
			}
		});

		add(this.file, BorderLayout.CENTER);
		add(this.button, BorderLayout.EAST);
		add(this.message, BorderLayout.SOUTH);
	}

	void chooseFile()
	{
		if (chooser.showOpenDialog(parent) == JFileChooser.APPROVE_OPTION)
		{
			File f = chooser.getSelectedFile();
			pretty(f);
			this.file.setText(this.prettyfier.getName(f));
		}
	}

	void pretty(File f)
	{
		this.file.setBorder(BorderFactory.createLineBorder(this.prettyfier.getColor(f)));
		this.message.setBackground(this.prettyfier.getColor(f).brighter());
		this.message.setText(this.prettyfier.getMessage(f));
	}

	public File getFile()
	{
		return new File(this.file.getText());
	}
}
