/*
 * Created on Apr 5, 2004
 */

package rfdd.gui;

import java.awt.Color;
import java.io.File;
import java.io.IOException;

/**
 * @author tnguyen
 *
 */
public abstract class FilePrettyfier
{
	public static final FilePrettyfier READONLY = new ReadOnly();
	public static final FilePrettyfier WRITE = new Write();

	public abstract Color getColor(File f);
	public abstract String getMessage(File f);

	public String getName(File f)
	{
		String n;
		try
		{
			n = f.getCanonicalPath();
		}
		catch (IOException e)
		{
			n = "Impossible de trouver le fichier";
		}
		return n;
	}
}

class ReadOnly extends FilePrettyfier
{
	public Color getColor(File f)
	{
		if (f.canRead() && !f.isDirectory())
			return Color.GREEN;
		else
			return Color.RED;
	}
	public String getMessage(File f)
	{
		if (f.canRead() && !f.isDirectory())
			return "OK";
		else if (!f.exists())
			return "Le fichier n'existe pas";
		else if (f.isDirectory())
			return "Le fichier est un répertoire";
		else
			return "Lecture du fichier impossible";
	}
}

class Write extends FilePrettyfier
{
	public Color getColor(File f)
	{
		if (!f.exists() && f.getName().length() > 0)
			return Color.GREEN;
		else if (f.canWrite())
			return Color.YELLOW;
		else
			return Color.RED;
	}
	public String getMessage(File f)
	{
		if (!f.exists() && f.getName().length() > 0)
			return "OK";
		else if (f.canWrite())
			return "Le fichier existe déjà, vous allez écraser son contenu actuel";
		else if (f.isDirectory())
			return "Le fichier est un répertoire";
		else
			return "Ecriture du fichier impossible";
	}
}
