/*
 * Created on Apr 15, 2004
 *
 */
package rfdd.gui;

import javax.swing.JTextField;

import rfdd.chainons.Chainon;
import rfdd.chainons.ChainonCalibration;

/**
 * @author tnguyen
 *
 */
public class WidgetChainonCalibration extends AbstractWidgetChainon
{
	private static final String DEFAULT_CALIBRE = "0.6";
	private JTextField calibre;

	public WidgetChainonCalibration()
	{
		super("Calibration");

		this.calibre = new JTextField(DEFAULT_CALIBRE, 10);
		addParam("calibre (%) : ", this.calibre);
	}

	public Chainon getChainon() throws BadParamException
	{
		try
		{
			float calibre = Float.parseFloat(this.calibre.getText().replace(',', '.'));
			return new ChainonCalibration(calibre / 100f);
		}
		catch (NumberFormatException e)
		{
			throw new BadParamException(
				"Impossible de convertir \"" + this.calibre.getText() + "\" en un nombre");
		}
	}

}
