/*
 * Created on Apr 19, 2004
 *
 */
package rfdd.gui;

import javax.swing.JTextField;

import rfdd.chainons.Chainon;
import rfdd.chainons.ChainonRecalculeProfil3;

/**
 * @author tnguyen
 *
 */
public class WidgetChainonRecalculeProfil extends AbstractWidgetChainon
{
	private static final String DEFAULT_SEUIL = "0.3";
	private JTextField seuil;

	public WidgetChainonRecalculeProfil()
	{
		super("Calcul des profils de réponse");

		this.seuil = new JTextField(DEFAULT_SEUIL, 10);
		addParam("Seuil de séparation des valeurs : ", this.seuil);
	}

	public Chainon getChainon() throws BadParamException
	{
		try
		{
			float seuil = Float.parseFloat(this.seuil.getText().replace(',', '.'));
			return new ChainonRecalculeProfil3(seuil);
		}
		catch (NumberFormatException e)
		{
			throw new BadParamException(
				"Impossible de convertir \"" + this.seuil.getText() + "\" en un nombre");
		}
	}

}
