package rfdd;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

import rfdd.chainons.ChainonAppariement;
import rfdd.chainons.ChainonCalibration;
import rfdd.chainons.ChainonDebug;
import rfdd.chainons.ChainonRealigneur;
import rfdd.chainons.ChainonRecalculeProfil;
import rfdd.chainons.ChainonRecalculeTailleRef;
import rfdd.chainons.LecteurFichier;
import rfdd.chainons.Pipeline;
import rfdd.chainons.SortieFichier;

/**
 * Interface ligne de commande pour le programme de traitement.
 * 
 * <nl>
 * <li>paramètre obligatoire: tolerance (décimal)
 * <li>paramètre optionnel: fichier en entrée (stdin par défaut)
 * <li>paramètre optionnel: fichier en sortie (stdout par défaut)
 * <nl>
 */
public class Main
{
	/**
	 * Interface ligne de commande pour le programme de traitement.
	 * 
	 * <nl>
	 * <li>paramètre optionnel: fichier en entrée (stdin par défaut)
	 * <li>paramètre optionnel: fichier en sortie (stdout par défaut)
	 * <nl>
	 * 
	 * @param args
	 * @throws IOException
	 */
	public static void main(String[] args) throws IOException
	{
		PrintWriter stderr = new PrintWriter(System.err, true);

		// le premier argument, s'il est présent, est le fichier d'entrée
		LecteurFichier entree;
		if (args.length >= 1 && !"-".equals(args[0]))
		{
			File infile = new File(args[0]);
			stderr.println("Fichier d'entrée: " + infile.getCanonicalPath());
			entree = new LecteurFichier(infile);
		}
		else
		{
			stderr.println("Lecture sur l'entrée standard");
			entree = new LecteurFichier();
		}

		// le deuxième argument, s'il est présent, est le fichier de sortie
		SortieFichier sortie;
		if (args.length >= 2 && !"-".equals(args[1]))
		{
			File outfile = new File(args[1]);
			stderr.println("Fichier de sortie: " + outfile.getCanonicalPath());
			sortie = new SortieFichier(outfile, "ISO-8859-1");
		}
		else
		{
			stderr.println("Ecriture sur la sortie standard");
			sortie = new SortieFichier();
		}

		//
		// préparation de la chaine de traitement
		//
		Pipeline pipe = new Pipeline();
		pipe.add(entree);
		//pipe.add(new ChainonDebug(stderr, "-"));
		pipe.add(new ChainonRealigneur(0.25f));
		pipe.add(new ChainonRecalculeTailleRef());
		pipe.add(new ChainonCalibration(0.006f));
		pipe.add(new ChainonRecalculeProfil(0.3f));
		pipe.add(new ChainonDebug(stderr, "<"));
		pipe.add(new ChainonAppariement(0.002f));
		//pipe.add(new ChainonSelectionneCompatibles());
		pipe.add(new ChainonDebug(stderr, ">"));
		pipe.add(sortie);

		stderr.println("Le pipeline est prêt: " + pipe);

		//
		// exécution de la chaine de traitement
		//
		pipe.run();

	}
}