package rfdd.chainons;

import rfdd.beans.GrandGroupe;
import rfdd.beans.ListeMesures;
import rfdd.beans.Mesure;
import rfdd.beans.PetitGroupe;

/**
 * Une interface évènementielle pour le traitement des données sous forme de "pipeline".
 *
 * <p>L'imbrication des <code>startXXXX()/stopXXXX()</code> doit être respectée.
 * 
 * <p><code>GrandGroupe</code> &gt; <code>PetitGroupeGrandGroupe &gt; <code>LigneGrandGroupe &gt; <code>MesureGrandGroupe
 * 
 * @author tnguyen
 *
 */
public interface Chainon
{
	/**
	 * Appelé au début du fichier.
	 * 
	 * @param fileName
	 */
	void startFichier(String fileName);
	
	/**
	 * Appellé au début d'un <code>GrandGroupe</code>.
	 * 
	 * @param gg
	 */
	void startGrandGroupe(GrandGroupe gg);
	
	/**
	 * Appellé au début d'un <code>PetitGroupe</code>.
	 * 
	 * @param pg
	 */
	void startPetitGroupe(PetitGroupe pg);
	
	/**
	 * Appellé au début d'une ligne.
	 * 
	 * @param l
	 */
	void startLigne(ListeMesures l);
	
	/**
	 * Appellé pour chaque mesure d'une ligne.
	 * 
	 * <p>(donc a priori 3 fois par ligne, à moins qu'on change le format du fichier d'entrée)
	 * 
	 * @param m
	 */
	void mesure(Mesure m);
	
	/**
	 * Appellé à la fin d'une ligne.
	 * 
	 * @param l
	 */
	void stopLigne(/*ListeMesures l*/);
	
	/**
	 * Appellé à la fin d'un <code>PetitGroupe</code>.
	 * 
	 * @param pg
	 */
	void stopPetitGroupe(/*PetitGroupe pg*/);
	
	/**
	 * Appellé à la fin d'un <code>GrandGroupe</code>.
	 * 
	 * @param gg
	 */
	void stopGrandGroupe(/*GrandGroupe gg*/);
	
	/**
	 * Appellé à la fin du fichier.
	 * 
	 * @param fileName
	 */
	void stopFichier(/*String fileName*/);
	
	/**
	 * Pointe ce chainon vers le chainon <code>suivant</code>.
	 * 
	 * <code>null</code> est une valeur acceptable.
	 * 
	 * @param suivant
	 */
	void linkTo(Chainon suivant);
}
