/*
 * Created on Apr 4, 2004
 */
package rfdd.chainons;

import rfdd.beans.ListeMesures;
import rfdd.beans.Mesure;
import rfdd.beans.PetitGroupe;

/**
 * Elimine les lignes dont la taille de référence est trop éloignée de la taille théorique de l'amplicon.
 * 
 * <p>En sortie, toutes les lignes vérifient l'inégalité:
 * <code>taille amplicon - calibre*tailleAmplicon &lt;= taille réf &lt;= taille amplicon + calibre*tailleAmplicon</code>.
 * 
 * @author tnguyen
 */
public class ChainonCalibration extends ChainonSimple
{
	private final float calibre;
	private boolean bloquerLigne;
	private float tailleAmplicon;

	public ChainonCalibration(float calibre)
	{
		this.calibre = calibre;
	}

	public void startPetitGroupe(PetitGroupe pg)
	{
		this.tailleAmplicon = (float) pg.getTailleAmplicon();

		super.startPetitGroupe(pg);
	}

	public void startLigne(ListeMesures l)
	{
		float tailleRef = l.getTailleRef();
		if (Float.isNaN(tailleRef))
			throw new IllegalArgumentException("la taille de référence n'a pas été recalculée");

		this.bloquerLigne =
			!(Math.abs(tailleRef - tailleAmplicon) <= this.calibre * tailleAmplicon);

		if (!this.bloquerLigne)
		{
			super.startLigne(l);
		}
	}

	public void mesure(Mesure m)
	{
		if (!this.bloquerLigne)
			super.mesure(m);
	}

	public void stopLigne()
	{
		if (!this.bloquerLigne)
			super.stopLigne();
	}

	public String toString()
	{
		return "{Calibration: calibre=" + this.calibre + "}";
	}

}
