/*
 * Created on May 27, 2004 by tnguyen
 */
package rfdd.chainons;

import java.util.ArrayList;
import java.util.List;

/**
 *  
 */
public final class ProfilUtil
{
	private static final char[] PROFILS = new char[] {'/', '-', '\\', 'A', 'V'};

	/**
	 * Retourne <code>true</code> ssi les deux profils ont un caractère en
	 * commun.
	 * 
	 * @param profil1
	 * @param profil2
	 * @return
	 */
	public static boolean compatibles(String profil1, String profil2)
	{

		for (int i = 0; i < PROFILS.length; i++)
		{
			if (profil1.indexOf(PROFILS[i]) != -1
					&& profil2.indexOf(PROFILS[i]) != -1)
			{
				return true;
			}
		}

		return false;
	}

	/**
	 * Retourne le profil fiable commun à <code>profil1</code> et
	 * <code>profil2</code>.
	 * 
	 * @param profil1
	 * @param profil2
	 * 
	 * @return le profil fiable
	 */
	public static String profilFiable(String profil1, String profil2)
	{

		if (profil1.charAt(0) == profil2.charAt(0))
		{
			// si le premier profil est identique, c'est le bon.
			return profil1.substring(0, 1);
		}
		else
		{
			StringBuffer sb = new StringBuffer();
			sb.append('(');
			for (int i = 0; i < PROFILS.length; i++)
			{
				if (profil1.indexOf(PROFILS[i]) != -1
						&& profil2.indexOf(PROFILS[i]) != -1)
				{
					sb.append(PROFILS[i]);
				}
			}
			sb.append(')');
			return sb.toString();
		}
	}

	/**
	 * Convertit la chaine de caractères en une liste de <code>Character</code>,
	 * plus facile à traiter automatiquement.
	 * 
	 * @param profil
	 * @return List&lt;Character&gt;
	 */
	public static List asList(String profil)
	{
		char[] p = profil.replaceAll(" ", "").replaceAll("\\(", "").replaceAll(
				"\\)", "").replaceAll("[0-9]*", "").toCharArray();

		List l = new ArrayList();
		for (int i = 0; i < p.length; i++)
			l.add(new Character(p[i]));

		return l;
	}

}