/*
 * Created on Apr 3, 2004
 */
package rfdd.chainons;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import rfdd.beans.GrandGroupe;
import rfdd.beans.ListeMesures;
import rfdd.beans.Mesure;
import rfdd.beans.PetitGroupe;
import rfdd.gui.evt.ProgressEvent;
import rfdd.gui.evt.ProgressListener;

/**
 * Dernier chainon d'une chaine de traitement.
 * 
 * <p>
 * Ecrit un tableau texte, avec les colonnes séparé par des tabulations et les
 * lignes par des retours chariot.
 * 
 * @author tnguyen
 *  
 */
public class SortieFichier extends ChainonSimple
{
	/**
	 * Le flux de sortie utilisé pour écrire.
	 */
	private final PrintWriter out;

	/**
	 * <code>PetitGroupe</code> en cours.
	 */
	private PetitGroupe pg;

	/**
	 * <code>GrandGroupe</code> en cours.
	 */
	private GrandGroupe gg;

	/**
	 * Utilisé pour construire la ligne au fur et à mesure.
	 */
	private String[] ligneTexte;

	/**
	 * Utile uniquement pour l'affichage debug.
	 */
	private String fileName = "N/C";

	/**
	 * Stocke le nombre de lignes écrites pour le suivi du traitement.
	 */
	private int lines = 0;

	/**
	 *  
	 */
	private NumberFormat nf = NumberFormat.getInstance(Locale.FRANCE);

	/**
	 * Construit un <code>SortieFichier</code> qui écrit dans un fichier.
	 * 
	 * TODO documenter le format du fichier de sortie
	 * 
	 * @param file le fichier de sortie
	 */
	public SortieFichier(File file, String charset) throws IOException
	{
		this(new PrintWriter(new OutputStreamWriter(new FileOutputStream(file),
				charset), true));
		this.fileName = file.getPath();
	}

	/**
	 * Construit un <code>SortieFichier</code> qui écrit sur la sortie
	 * standard.
	 */
	public SortieFichier()
	{
		this(new PrintWriter(System.out, true));
		this.fileName = "<stdout>";
	}

	/**
	 * Construit un <code>SortieFichier</code> qui écrit dans un flux de
	 * caractères.
	 * 
	 * @deprecated 
	 * @param out
	 */
	private SortieFichier(PrintWriter out)
	{
		this.out = out;
		this.ligneTexte = new String[23];
	}

	public void stopFichier()
	{
		this.out.flush();
		this.out.close();
	}

	public void startLigne(ListeMesures fragment)
	{
		//préparation de la ligne à imprimer
		this.ligneTexte[0] = nf.format(pg.getNoPCR());
		this.ligneTexte[1] = pg.getAmorce();
		this.ligneTexte[2] = nf.format(fragment.getTailleRef());
		this.ligneTexte[3] = nf.format(pg.getTailleAmplicon());
		this.ligneTexte[4] = "0"; //taille_Hp
		this.ligneTexte[5] = "0"; //taille_Hm
		this.ligneTexte[6] = "0"; //taille_N
		this.ligneTexte[7] = "0"; //fluo_Hp
		this.ligneTexte[8] = "0"; //fluo_Hm
		this.ligneTexte[9] = "0"; //fluo_N
		this.ligneTexte[10] = fragment.getCodeBiChar();
		this.ligneTexte[11] = fragment.getProfil();
		this.ligneTexte[12] = fragment.getProfilFiable();
		this.ligneTexte[13] = gg.getProfilMajoritaire();
		this.ligneTexte[14] = this.gg.getNoGenBank();
		this.ligneTexte[15] = this.gg.getGene();
		this.ligneTexte[16] = this.gg.getProduct();
		this.ligneTexte[17] = this.gg.getRedondance();
		this.ligneTexte[18] = this.pg.getTripletDebut();
		this.ligneTexte[19] = this.pg.getTripletFin();
		this.ligneTexte[20] = this.gg.getRun();
		this.ligneTexte[21] = fragment.getProfilEnClair();
		this.ligneTexte[22] = this.pg.getEnzyme();
	}

	public void stopLigne()
	{
		//impression effective de la ligne
		this.out.print(this.ligneTexte[0]);
		for (int i = 1; i < this.ligneTexte.length; i++)
		{
			this.out.print("\t");
			this.out.print((this.ligneTexte[i] != null) ? this.ligneTexte[i]
					: "");
		}
		this.out.println();

		this.lines++;

		// notifie les écouteurs qu'une ligne à été écrite.
		Iterator it = listeners.iterator();
		ProgressEvent pe = new ProgressEvent(this, -1, this.lines);
		while (it.hasNext())
		{
			((ProgressListener) it.next()).lineWritten(pe);
		}

	}

	public void mesure(Mesure m)
	{
		//Met les mesures dans les bonnes colonnes
		if ("Hp".equals(m.getConditions()))
		{
			this.ligneTexte[4] = nf.format(m.getTaille());
			this.ligneTexte[7] = nf.format(m.getFluo());
		}
		else if ("Hm".equals(m.getConditions()))
		{
			this.ligneTexte[5] = nf.format(m.getTaille());
			this.ligneTexte[8] = nf.format(m.getFluo());
		}
		else if ("N".equals(m.getConditions()))
		{
			this.ligneTexte[6] = nf.format(m.getTaille());
			this.ligneTexte[9] = nf.format( m.getFluo());
		}
	}

	/**
	 * Lance toujours l'exception <code>UnsupportedOperationException</code>.
	 * 
	 * <p>
	 * Puisque <code>SortieFichier</code> est un chainon final, il ne doit pas
	 * y en avoir de suivant.
	 * 
	 * @throws UnsupportedOperationException
	 */
	public void linkTo(Chainon c)
	{
		throw new UnsupportedOperationException(
				"Impossible de chainer SortieFichier"
						+ " avec un autre chainon,"
						+ " SortieFichier est un chainon final.");
	}

	public String toString()
	{
		return "{SortieFichier: fichier=" + this.fileName + "}";
	}

	/**
	 * Imprime une ligne pour les en-tête de colonne
	 */
	public void startFichier(String fileName)
	{
		//préparation de la ligne à imprimer
		this.ligneTexte[0] = "n°PCR";
		this.ligneTexte[1] = "amorce";
		this.ligneTexte[2] = "taille-réf";
		this.ligneTexte[3] = "taille-amplicon";
		this.ligneTexte[4] = "taille_Hp";
		this.ligneTexte[5] = "taille_Hm";
		this.ligneTexte[6] = "taille_N";
		this.ligneTexte[7] = "fluo_Hp";
		this.ligneTexte[8] = "fluo_Hm";
		this.ligneTexte[9] = "fluo_N";
		this.ligneTexte[10] = "bichar";
		this.ligneTexte[11] = "profil";
		this.ligneTexte[12] = "fiable";
		this.ligneTexte[13] = "majoritaire";
		this.ligneTexte[14] = "n°GeneBank";
		this.ligneTexte[15] = "gene";
		this.ligneTexte[16] = "product";
		this.ligneTexte[17] = "redondance";
		this.ligneTexte[18] = "triplet-début";
		this.ligneTexte[19] = "triplet-fin";
		this.ligneTexte[20] = "run";
		this.ligneTexte[21] = "profil en clair";
		this.ligneTexte[22] = "enzyme";

		//impression effective de la ligne
		this.out.print(this.ligneTexte[0]);
		for (int i = 1; i < this.ligneTexte.length; i++)
		{
			this.out.print("\t");
			this.out.print(this.ligneTexte[i]);
		}
		this.out.println();

		this.lines = 1;
	}

	public void startGrandGroupe(GrandGroupe gg)
	{
		this.gg = gg;
	}

	public void startPetitGroupe(PetitGroupe pg)
	{
		this.pg = pg;
	}

	private List listeners = new ArrayList();

	public void addProgressListener(ProgressListener pl)
	{
		this.listeners.add(pl);
	}

	public void removeProgressListener(ProgressListener pl)
	{
		this.listeners.remove(pl);
	}
}