/*
 * Created on May 27, 2004 by tnguyen
 */
package rfdd.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

import rfdd.gui.evt.ProgressEvent;
import rfdd.gui.evt.ProgressListener;

/**
 *  
 */
public class ProgressDialog extends JDialog implements ProgressListener
{
	private JLabel info;
	private JTextField nbLignesLues;
	private JTextField nbLignesEcrites;
	private JButton close;

	int lignesEcrites;
	int lignesLues;

	public ProgressDialog(JFrame owner)
	{
		super(owner, "Analyse du fichier", true);
	}

	protected void dialogInit()
	{
		super.dialogInit();

		this.info = new JLabel("Traitement en cours");
		this.info.setHorizontalAlignment(SwingConstants.CENTER);
		this.info.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		this.info.setBackground(Color.CYAN);
		this.getContentPane().add(this.info, BorderLayout.NORTH);

		JPanel contenu = new JPanel();
		contenu.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		contenu.setLayout(new GridLayout(2, 2, 10, 10));

		JLabel labelLignesLues = new JLabel("Nombre de lignes lues: ", SwingConstants.RIGHT);
		contenu.add(labelLignesLues);

		this.nbLignesLues = new JTextField(6);
		this.nbLignesLues.setEditable(false);
		this.nbLignesLues.setBackground(Color.WHITE);
		contenu.add(this.nbLignesLues);

		JLabel labelLignesEcrites = new JLabel("Nombre de lignes écrites: ", SwingConstants.RIGHT);
		contenu.add(labelLignesEcrites);

		this.nbLignesEcrites = new JTextField(6);
		this.nbLignesEcrites.setEditable(false);
		this.nbLignesEcrites.setBackground(Color.WHITE);
		contenu.add(this.nbLignesEcrites);

		this.getContentPane().add(contenu, BorderLayout.CENTER);

		this.close = new JButton("Fermer");
		this.close.setEnabled(false);

		JPanel panelBas = new JPanel();
		panelBas.setLayout(new FlowLayout());
		panelBas.add(this.close);

		this.getContentPane().add(panelBas, BorderLayout.SOUTH);
	}

	public void setInfo(String message)
	{
		this.info.setText(message);
	}

	/*
	 * @see rfdd.gui.evt.ProgressListener#lineRead(rfdd.gui.evt.ProgressEvent)
	 */
	public void lineRead(ProgressEvent pe)
	{
		this.lignesLues = pe.getLinesRead();
		if (this.lignesLues % 10 == 0)
		{
			SwingUtilities.invokeLater(new Runnable()
			{
				public void run()
				{
					nbLignesLues.setText(Integer.toString(lignesLues));
				}
			});
		}
	}

	/*
	 * @see rfdd.gui.evt.ProgressListener#lineWritten(rfdd.gui.evt.ProgressEvent)
	 */
	public void lineWritten(ProgressEvent pe)
	{
		this.lignesEcrites = pe.getLinesWritten();
		if (this.lignesEcrites % 10 == 0)
				this.nbLignesEcrites.setText(Integer.toString(this.lignesEcrites));
	}

	/**
	 * Signale au dialog que le traitement est terminé, et qu'on peut maintenant
	 * fermer.
	 * 
	 * @throws InterruptedException
	 */
	public void allowClose()
	{
		this.nbLignesLues.setText(Integer.toString(this.lignesLues));
		this.nbLignesEcrites.setText(Integer.toString(this.lignesEcrites));

		this.close.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent arg0)
			{
				close();
			}
		});

		this.close.setEnabled(true);
	}

	private void close()
	{
		this.setVisible(false);
		this.dispose();
	}

}