/*
 * Created on Apr 23, 2004
 *
 */
package rfdd.gui;

import javax.swing.JTextField;

import rfdd.chainons.Chainon;
import rfdd.chainons.ChainonAppariement;

/**
 * @author tnguyen
 *
 */
public class WidgetChainonAppariement extends AbstractWidgetChainon
{
	private static final String DEFAULT_PRECISION = "0.2";
	private JTextField precision;

	public WidgetChainonAppariement()
	{
		super("repérage des 2 extrémités d'un même fragment");

		this.precision = new JTextField(DEFAULT_PRECISION, 10);
		addParam("précision : ", precision);
	}

	public Chainon getChainon() throws BadParamException
	{
		if (actif())
		{
			try
			{
				float precision =
					Float.parseFloat(this.precision.getText().replace(',', '.'));
				return new ChainonAppariement(precision);
			}
			catch (NumberFormatException nfe)
			{
				throw new BadParamException(
					"Impossible de convertir \"" + this.precision.getText() + "\" en un nombre");
			}
		}
		else
		{
			return null;
		}
	}

}
