/*
 * Created on Apr 12, 2004
 *
 */
package rfdd.gui;

import javax.swing.JTextField;

import rfdd.chainons.Chainon;
import rfdd.chainons.ChainonRealigneur;

/**
 * @author tnguyen
 *
 */
public class WidgetChainonRealigneur extends AbstractWidgetChainon
{
	private static final String DEFAULT_SEUIL = "0.25";

	private JTextField jSeuil;

	public WidgetChainonRealigneur()
	{
		super("réalignement");

		this.jSeuil = new JTextField(DEFAULT_SEUIL, 10);
		addParam("seuil:", this.jSeuil);
	}

	public Chainon getChainon() throws BadParamException
	{
		try
		{
			float seuil = Float.parseFloat(this.jSeuil.getText().replace(',', '.'));
			return new ChainonRealigneur(seuil);
		}
		catch (NumberFormatException e)
		{
			throw new BadParamException(
				"Impossible de convertir \"" + this.jSeuil.getText() + "\" en un nombre");
		}
	}
}
