% This program is dedicated to the analysis of array CGH experiments
% Theoretical references can be found in the tech report
% Picard F, Robin S, Lavielle M, Vaisse C, Daudin J.J (2004), 
% A statistical approach for CGH microarray data analysis, 
% Institut National de la Recherche en Informatique et en Automatique, RR5139
% www.inria.fr/rrrt/rr-5139.html
% The data set provided is from Snijders & al (2001), Nat Genet 29,263-264.
%
%*************************************************************************
%
% input file format : .txt, 
% 4 columns : BAC name, log2ratio, position in kb, chromosome number
%
% output file format: .txt
% 7 columns chromosome under study 
%				beginning breakpoint coordinate
%				ending breakpoint coordinate
%				beginning BAC
%				ending BAC
%				mean log2ratio for segment k
%				standard deviation for segment k
% 
% the path directory has to be specified by users
%*************************************************************************
% Franck Picard, Nathalie Coqu (july 2004)
%*************************************************************************

global don lmin S debut fin chz i KhS KmS JS Kmchoix;
close all hidden;
[BAC,modele,critere,Kmchoix,graphe,grapheL,fid,beta]	=	SpeOption;

for i=1 : length(chz)
   [Y,Km]				= Init(modele,Kmchoix,fid);
	[J,th]            = segmentation(Y,Km,modele);
	[Kh]              = selection(Y,J,Km,modele,critere);
   [coord_beg,coord_end,bac_beg,bac_end,muk,sigmak]				 = estimation(Y,th,Kh,modele,BAC);
   
   if or(graphe(1)=='Y',graphe(1)=='y')   
   	graphique(th,Kh,modele);
   end;
   Sortie(Kh,coord_beg,coord_end,bac_beg,bac_end,muk,sigmak,fid);
end;

for j=1 : length(chz)
   if or(grapheL(1)=='Y',grapheL(1)=='y')   
      graphL(j,modele,critere);
   end;
end;

fclose(fid);

