function G=Gmean_std(Y,lmin)

%*****************************************************************************
% This function calculates the cost matrix for an heteroscedastic model
%*****************************************************************************

n=length(Y);
Y=reshape(Y,1,n);
G=repmat(Inf,n,n); G=tril(G,lmin-2);
Yi=cumsum(Y); Yi=Yi(lmin:n);
Y2=Y.^2;
Y2i=cumsum(Y2);Y2i=Y2i(lmin:n);
G(1,lmin:n)=(lmin:n).*log((Y2i-(Yi.^2)./(lmin:n))./(lmin:n));

for i=2:n-lmin+1
   ni=n-i-lmin+3;
   Y2i=Y2i(2:ni)-Y2(i-1);
   Yi=Yi(2:ni)-Y(i-1);
   vi = (lmin:n-i+1);
   G(i,i+lmin-1:n)=vi.*log((Y2i-(Yi.^2)./vi)./vi);
end;

