function [BAC,modele,critere,Kmchoix,graphe,grapheL,fid,beta]	=	SpeOption;

%*****************************************************************************
% Specifying options
% No :
% 		model 2 : homoscedastic
%		critere 1 : selection Marc Lavielle
%		Km = 20
%		with graphes (Log_2 rat & Likelihood)
%		output : result.txt
%
% Yes :
% 		model 1 or 2 : heteroscedastic or homoscedastic
%		critere 1 to 5 : selection 1:Marc Lavielle, 2:Emilie Lebarbier, 3:AIC, 4:BIC, 5:beta
%		Km = choice
%		with or without graphes : N or Y
%		output : _.txt
%*****************************************************************************

global don chz KhS KmS JS Kmchoix lmin S debut fin;

%*****************************************************************************
% read data file
%*****************************************************************************

path=input('Path directory : (default : "C:\\MATLABR11\\work\\")  ','s');
fichier=input('Name of the input data file (.txt): ','s');
[BAC,log2rat,pos,chrom]=textread([char(path) char(fichier) '.txt'],'%s %f %f %d');


%*****************************************************************************
% Specifying options
%*****************************************************************************

disp('Specifying options ? (''N'' : model homoscedastic, selection Marc Lavielle, Km=20, graphes, result.txt) ');
option=input('(N/Y) : ','s');
beta=0;
if or(option(1)=='N',option(1)=='n')
   modele=2;	
   model='homoscedastic';
   critere=1;	
   selection='Marc Lavielle';
   Kmchoix=20;
   graphe='Y';
   grapheL='Y';
   result='result.txt';
   
elseif or(option(1)=='Y',option(1)=='y')
   modele=input('Model (1:heteroscedastique /2:homo) = ');
   if modele==1
      model='heteroscedastic';
   elseif modele==2
      model='homoscedastic';
   end;
   
   critere=input('Selection (1:Marc Lavielle, 2:Emilie Lebarbier, 3:AIC, 4:BIC, 5:?) = ');
   if critere==1
      selection='Marc Lavielle';
   elseif critere==2
      selection='Emilie Lebarbier';
   elseif critere==3
      selection='AIC';
   elseif critere==4
      selection='BIC';
   elseif critere==5
      beta=input('beta= ');
		selection='autre';
   end;
	Kmchoix=input('Km = ');
   graphe=input('Log_2 rat graph ? (N/Y) ','s');
   grapheL=input('Likelihood graph ? (N/Y) ','s');   
   result=input('Name of output data file ? : ','s');
   result=[char(result),'.txt'];

end;


%*****************************************************************************
% Chromosomes under study :
% write the n of a chromosome or ''all'' if you want to analyse all chromosomes
%*****************************************************************************

chz=0;autre=0;c=0;
chz=input('Which chromosome ?(write the n or ''all'') ','s');
if chz(1)=='a' & chz(2)=='l' & chz(3)=='l'
   chz=[1];
   for i=2 : chrom(end)
      c=i;
      chz=[chz c];
   end;
else
	chz=str2double(chz);   
	autre=input('Another one (else 0) ');
	while autre ~= 0
		chz=[chz autre];
   	autre=input('Another one (else 0) ');
	end;
end;


%*****************************************************************************
% Write your choice on the screen and in the output data file
%*****************************************************************************

disp(' ');
disp(['Data File : ',fichier,'.txt']);
disp(['Model : ',model]);
disp(['Selection : ',selection]);
disp(['Km : ',num2str(Kmchoix)]);
if critere==5
   disp(['Beta : ',num2str(beta)]);
end;
disp(' ');
disp('chz coord_beg coord_end BAC_beg	  BAC_end      mu_k    sigma_k');

fid=fopen(result,'w');
fprintf(fid,'%s%s%s\n','Data File : ',fichier,'.txt');
fprintf(fid,'%s%s\n','Model : ',model);
fprintf(fid,'%s%s\n','Selection : ',selection);
fprintf(fid,'%s%2d\n','Km : ',Kmchoix);
if critere==5
   fprintf(fid,'%s%2d\n','Beta : ',beta);
end;
fprintf(fid,'\n%3s\t%8s\t%8s\t%8s\t%8s\t%10s\t%10s\n','chrom','coord_beg','coord_end','BAC_beg','BAC_end','mu_k','sigma_k');


%*****************************************************************************
% Initialization of variables
%*****************************************************************************
don=[log2rat,pos,chrom];
KhS=[];
KmS=[];
JS=[];
debut=[];
fin=[];
S=0.5;
if modele==1
  	lmin=2;
elseif modele==2
 	lmin=1;
end;




