function [J,th]=dynprog(G,Km);
% function [J,th]=dynprog(G,Km)
%*****************************************************************************
% This function ...
% th  : coordonnees de la fin des ruptures
% G   : matrice de cot
% Km  : nb de segments max que l'on veut
%*****************************************************************************

[N,N]=size(G);						
I   = repmat(Inf,Km,N);	
t   = zeros(Km-1,N);			
I(1,:)=G(1,:);				
if Km>2,
    for k=2:Km-1,			
        for L=k:N
            [I(k,L),t(k-1,L)] = min(I(k-1,1:L-1)+G(2:L,L)');
        end;
    end;
end;
[I(Km,N),t(Km-1,N)] = min(I(Km-1,1:N-1)+G(2:N,N)');
J=I(:,N);

% *** Compute the change-points instants ***
th = diag(repmat(N,Km,1));
for K=2:Km,
        for k=K-1:-1:1,
            th(K,k) = t(k,th(K,k+1));
        end;
end;
