function [km,kv,pv]=penteexplo(J,pen)

%*****************************************************************************
% penalty constant estimation
% Emilie Lebarbier
%*****************************************************************************

K=length(J);
k=1;
kv=[];
dv=[];
pv=[];
dmax=1;
while k<K
	pk=(J(k+1:K)-J(k))./(pen(k)-pen(k+1:K));
	[pm,dm]=max(pk);
	kv=[kv k];
	dv=[dv dm];
	pv=[pv pm];
	if dm>dmax;  dmax=dm; kmax=k; pmax=pm;  end;
	k=k+dm;
end;

kv=[kv K];
pv=[pv 0];
dv=diff(kv);
[dmax,rmax]=max(dv);
rg=find(dv==dmax);
pmax=pv(rg(end));
alpha=2*pmax;
rt=find(alpha>=pv);
km=kv(rt(1));


